/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.test.AbstractTestGraphMaker;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.util.HashSet;
import junit.framework.TestSuite;

public class TestFileGraphMaker
extends AbstractTestGraphMaker {
    public TestFileGraphMaker(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileGraphMaker.class);
    }

    public GraphMaker getGraphMaker() {
        String scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker").getPath();
        return new FileGraphMaker(scratch, ReificationStyle.Minimal, true);
    }

    public void testToFilename() {
        TestFileGraphMaker.assertEquals((String)"plain", (String)FileGraphMaker.toFilename("plain"));
        TestFileGraphMaker.assertEquals((String)"with_Sslash", (String)FileGraphMaker.toFilename("with/slash"));
        TestFileGraphMaker.assertEquals((String)"with_Ccolon", (String)FileGraphMaker.toFilename("with:colon"));
        TestFileGraphMaker.assertEquals((String)"with_Uunderbar", (String)FileGraphMaker.toFilename("with_underbar"));
        TestFileGraphMaker.assertEquals((String)"with_Stwo_Sslashes", (String)FileGraphMaker.toFilename("with/two/slashes"));
        TestFileGraphMaker.assertEquals((String)"with_Sa_Cmixture_U...", (String)FileGraphMaker.toFilename("with/a:mixture_..."));
    }

    public void testToGraphname() {
        TestFileGraphMaker.assertEquals((String)"plain", (String)FileGraphMaker.toGraphname("plain"));
        TestFileGraphMaker.assertEquals((String)"with/slash", (String)FileGraphMaker.toGraphname("with_Sslash"));
        TestFileGraphMaker.assertEquals((String)"with:colon", (String)FileGraphMaker.toGraphname("with_Ccolon"));
        TestFileGraphMaker.assertEquals((String)"with_underbar", (String)FileGraphMaker.toGraphname("with_Uunderbar"));
        TestFileGraphMaker.assertEquals((String)"a/mixture_of:things", (String)FileGraphMaker.toGraphname("a_Smixture_Uof_Cthings"));
        TestFileGraphMaker.assertEquals((String)"with/two/slashes", (String)FileGraphMaker.toGraphname("with_Stwo_Sslashes"));
    }

    public void testDetectsExistingFiles() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-already");
        Graph content = TestFileGraphMaker.graphWith("something hasProperty someValue");
        FileGraphMaker A = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        FileGraphMaker B = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        FileGraph gA = (FileGraph)A.createGraph("already", true);
        gA.getBulkUpdateHandler().add(content);
        gA.close();
        FileGraph gB = (FileGraph)B.openGraph("already", false);
        TestFileGraphMaker.assertIsomorphic(content, gB);
        gB.close();
        gB.delete();
        gA.delete();
    }

    public void testDeletesFilesOfClosedMaker() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-forgets");
        FileGraphMaker A = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        A.createGraph("empty").close();
        TestFileGraphMaker.assertTrue((String)("file 'empty' should exist in '" + scratch + "'"), (boolean)new File(scratch, "empty").exists());
        A.close();
        TestFileGraphMaker.assertFalse((String)("file 'empty' should no longer exist in '" + scratch + "'"), (boolean)new File(scratch, "empty").exists());
    }

    public void testForgetsClosedGraphs() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-forgets");
        FileGraphMaker m = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        m.createGraph("example").close();
        TestFileGraphMaker.assertEquals(new HashSet(), (Object)TestFileGraphMaker.iteratorToSet(m.listGraphs()));
        m.close();
    }

    public void testDoesntReusedClosedGraphs() {
        File scratch = FileUtils.getScratchDirectory("jena-test-FileGraphMaker-noReuse");
        FileGraphMaker m = new FileGraphMaker(scratch.getPath(), ReificationStyle.Minimal, true);
        Graph m1 = m.createGraph("hello");
        m1.close();
        Graph m2 = m.createGraph("hello");
        TestFileGraphMaker.assertNotSame((Object)m1, (Object)m2);
        m2.add(TestFileGraphMaker.triple("this graph isOpen"));
        m.close();
    }
}

