/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.HashedTripleBunch;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.mem.test.TestTripleBunch;

public class TestHashedTripleBunch
extends TestTripleBunch {
    HashedTripleBunch htb = new HTB(emptyBunch);

    public TestHashedTripleBunch(String name) {
        super(name);
    }

    public TripleBunch getBunch() {
        return new HashedTripleBunch(emptyBunch);
    }

    public void testHashcodeUsedAsIndex() {
        HTB htb = new HTB(emptyBunch);
        int limit = htb.currentCapacity();
        for (int i = 0; i < limit; ++i) {
            TripleWithHash t = TripleWithHash.create(i, "s p o");
            htb.add(t);
            TestHashedTripleBunch.assertSame((Object)t, (Object)htb.getItemForTestingAt(i));
        }
    }

    public void testRemovePerformsShiftFromTop() {
        int capacity = this.htb.currentCapacity();
        this.testRemovePerformsShift(capacity - 1, capacity);
    }

    public void testRemovePerformsShiftFromMiddle() {
        int capacity = this.htb.currentCapacity();
        this.testRemovePerformsShift(capacity - 3, capacity);
    }

    public void testRemovePerformsShiftWrappingLowestTwo() {
        int capacity = this.htb.currentCapacity();
        this.testRemovePerformsShift(0, capacity);
    }

    public void testRemovePerformsShiftWrappingLowest() {
        int capacity = this.htb.currentCapacity();
        this.testRemovePerformsShift(1, capacity);
    }

    private void testRemovePerformsShift(int most, int capacity) {
        int least;
        int next = most - 1;
        if (next < 0) {
            next += capacity;
        }
        if ((least = most - 2) < 0) {
            least += capacity;
        }
        TripleWithHash t1 = TripleWithHash.create(most, "s p o");
        TripleWithHash t2 = TripleWithHash.create(next, "a b c");
        TripleWithHash t3 = TripleWithHash.create(most, "x y z");
        this.htb.add(t1);
        this.htb.add(t2);
        this.htb.add(t3);
        TestHashedTripleBunch.assertSame((Object)t1, (Object)this.htb.getItemForTestingAt(most));
        TestHashedTripleBunch.assertSame((Object)t2, (Object)this.htb.getItemForTestingAt(next));
        TestHashedTripleBunch.assertSame((Object)t3, (Object)this.htb.getItemForTestingAt(least));
        this.htb.remove(t1);
        TestHashedTripleBunch.assertSame((Object)t3, (Object)this.htb.getItemForTestingAt(most));
        TestHashedTripleBunch.assertSame((Object)t2, (Object)this.htb.getItemForTestingAt(next));
        TestHashedTripleBunch.assertSame(null, (Object)this.htb.getItemForTestingAt(least));
    }

    public void testIteratorRemovePerformsShiftAndDeliversElementFromTop() {
        int capacity = this.htb.currentCapacity();
        this.testIteratorRemovePerformsShiftAndDeliversElement(capacity - 1, capacity);
    }

    public void testIteratorRemovePerformsShiftAndDeliversElementFromMiddle() {
        int capacity = this.htb.currentCapacity();
        this.testIteratorRemovePerformsShiftAndDeliversElement(capacity - 3, capacity);
    }

    private void testIteratorRemovePerformsShiftAndDeliversElement(int most, int capacity) {
    }

    static class TripleWithHash
    extends Triple {
        final int hash;

        TripleWithHash(int hash, Node s, Node p, Node o) {
            super(s, p, o);
            this.hash = hash;
        }

        public static TripleWithHash create(int n, String s) {
            Triple t = GraphTestBase.triple(s);
            return new TripleWithHash(n, t.getSubject(), t.getPredicate(), t.getObject());
        }

        public int hashCode() {
            return this.hash;
        }
    }

    protected static class HTB
    extends HashedTripleBunch {
        public HTB(TripleBunch b) {
            super(b);
        }

        protected int improveHashCode(int hashCode) {
            return hashCode;
        }
    }
}

