/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.turtle.test;

import com.hp.hpl.jena.n3.turtle.TurtleReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import junit.framework.TestCase;

public class TestTurtle
extends TestCase {
    String input;
    String output;
    String baseIRI;

    public TestTurtle(String name, String input, String output, String baseIRI) {
        super(name);
        this.input = input;
        this.output = output;
        this.baseIRI = baseIRI;
    }

    public void runTest() {
        Model model = ModelFactory.createDefaultModel();
        TurtleReader t = new TurtleReader();
        if (this.baseIRI != null) {
            t.read(model, FileManager.get().open(this.input), this.baseIRI);
        } else {
            t.read(model, this.input);
        }
        String syntax = FileUtils.guessLang(this.output, "N-TRIPLE");
        Model results = FileManager.get().loadModel(this.output, syntax);
        boolean b = model.isIsomorphicWith(results);
        if (!b) {
            TestTurtle.assertTrue((String)"Models not isomorphic", (boolean)b);
        }
    }
}

