/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.OntDocManagerVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestOntDocumentManager
extends TestCase {
    private static Boolean F = Boolean.FALSE;
    private static Boolean T = Boolean.TRUE;
    private static Log log = LogFactory.getLog(TestOntDocumentManager.class);
    public static Object[][] s_testData = new Object[][]{{"testing/ontology/testImport1", TestOntDocumentManager.cnt(1), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(1), F, null}, {"testing/ontology/testImport3", TestOntDocumentManager.cnt(3), T, null}, {"testing/ontology/testImport4", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport5", TestOntDocumentManager.cnt(2), T, "file:testing/ontology/testImport5/ont-policy.rdf"}};

    public static final Integer cnt(int x) {
        return new Integer(x);
    }

    public TestOntDocumentManager(String s) {
        super(s);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite("TestOntDocumentManager");
        suite.addTestSuite(TestOntDocumentManager.class);
        for (int i = 0; i < s_testData.length; ++i) {
            suite.addTest((Test)new DocManagerImportTest((String)s_testData[i][0], (Integer)s_testData[i][1], (Boolean)s_testData[i][2], (String)s_testData[i][3]));
        }
        return suite;
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
        HashSet modelNames = new HashSet();
        ModelMaker memMaker = OntModelSpec.OWL_MEM.getImportModelMaker();
        Iterator i = memMaker.listModels();
        while (i.hasNext()) {
            modelNames.add(i.next());
        }
        i = modelNames.iterator();
        while (i.hasNext()) {
            String mn = (String)i.next();
            memMaker.removeModel(mn);
        }
    }

    public void testConstruct0() {
        OntDocumentManager m = new OntDocumentManager();
        TestOntDocumentManager.assertNotNull((Object)m);
        TestOntDocumentManager.assertEquals((String)m.getMetadataSearchPath(), (String)"file:ont-policy.rdf;file:etc/ont-policy.rdf");
    }

    public void testConstruct1() {
        OntDocumentManager mgr = new OntDocumentManager("");
        TestOntDocumentManager.assertTrue((String)"Should be no specification loaded", (!mgr.listDocuments().hasNext() ? (byte)1 : 0) != 0);
    }

    public void testConstruct2() {
        OntDocumentManager mgr = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue((String)"Should be no specification loaded", (!mgr.listDocuments().hasNext() ? (byte)1 : 0) != 0);
    }

    public void testConstruct3() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addProperty(RDF.type, OntDocManagerVocab.OntologySpec);
        r.addProperty(OntDocManagerVocab.publicURI, m.createResource("http://example.com/foo"));
        r.addProperty(OntDocManagerVocab.altURL, m.createResource("file:local.rdf"));
        OntDocumentManager mgr = new OntDocumentManager(m);
        TestOntDocumentManager.assertEquals((String)"cache URL not correct", (String)"file:local.rdf", (String)mgr.doAltURLMapping("http://example.com/foo"));
    }

    public void testInitialisation() {
        OntDocumentManager mgr = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue((String)"Should be at least one specification loaded", (boolean)mgr.listDocuments().hasNext());
        TestOntDocumentManager.assertNotNull((String)"cache URL for owl should not be null", (Object)mgr.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals((String)"cache URL for owl not correct", (String)"file:vocabularies/owl.owl", (String)mgr.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals((String)"prefix for owl not correct", (String)"owl", (String)mgr.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
    }

    public void testGetInstance() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        TestOntDocumentManager.assertNotNull((Object)odm);
        OntDocumentManager odm2 = OntDocumentManager.getInstance();
        TestOntDocumentManager.assertSame((Object)odm, (Object)odm2);
    }

    public void testSetMetadataSearchPath() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"file:etc/ont-policy-test.rdf", (String)odm.getMetadataSearchPath());
        TestOntDocumentManager.assertTrue((boolean)odm.listDocuments().hasNext());
        TestOntDocumentManager.assertEquals((String)"file:etc/ont-policy-test.rdf", (String)odm.getLoadedPolicyURL());
        odm.setMetadataSearchPath("file:notexist.rdf", false);
        TestOntDocumentManager.assertTrue((boolean)odm.listDocuments().hasNext());
        TestOntDocumentManager.assertNull((Object)odm.getLoadedPolicyURL());
        odm.setMetadataSearchPath("file:notexist.rdf", true);
        TestOntDocumentManager.assertFalse((boolean)odm.listDocuments().hasNext());
        TestOntDocumentManager.assertNull((Object)odm.getLoadedPolicyURL());
        odm.setMetadataSearchPath("file:etc/ont-policy-test.rdf", false);
        TestOntDocumentManager.assertTrue((boolean)odm.listDocuments().hasNext());
        TestOntDocumentManager.assertEquals((String)"file:etc/ont-policy-test.rdf", (String)odm.getLoadedPolicyURL());
    }

    public void testConfigure0() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addProperty(RDF.type, OntDocManagerVocab.OntologySpec);
        r.addProperty(OntDocManagerVocab.publicURI, m.createResource("http://example.com/foo"));
        r.addProperty(OntDocManagerVocab.altURL, m.createResource("file:local.rdf"));
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestUtil.assertIteratorLength(odm.listDocuments(), 3);
        odm.configure(m, false);
        TestUtil.assertIteratorLength(odm.listDocuments(), 4);
    }

    public void testConfigure1() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource();
        r.addProperty(RDF.type, OntDocManagerVocab.OntologySpec);
        r.addProperty(OntDocManagerVocab.publicURI, m.createResource("http://example.com/foo"));
        r.addProperty(OntDocManagerVocab.altURL, m.createResource("file:local.rdf"));
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestUtil.assertIteratorLength(odm.listDocuments(), 3);
        odm.configure(m);
        TestUtil.assertIteratorLength(odm.listDocuments(), 1);
    }

    public void testConfigure2() {
        Model m = ModelFactory.createDefaultModel();
        Resource policy = m.createResource();
        m.add(policy, RDF.type, OntDocManagerVocab.DocumentManagerPolicy);
        m.addLiteral(policy, OntDocManagerVocab.cacheModels, false);
        OntDocumentManager mgr = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue((boolean)mgr.getCacheModels());
        mgr.configure(m);
        TestOntDocumentManager.assertFalse((String)"Docmgr configure() should have updated cache models flag", (boolean)mgr.getCacheModels());
    }

    public void testReset() {
        OntDocumentManager mgr = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertTrue((boolean)mgr.getProcessImports());
        mgr.setProcessImports(false);
        TestOntDocumentManager.assertFalse((boolean)mgr.getProcessImports());
        mgr.reset();
        TestOntDocumentManager.assertTrue((boolean)mgr.getProcessImports());
        mgr.setMetadataSearchPath("file:foo.xml", true);
        TestOntDocumentManager.assertEquals((String)"file:foo.xml", (String)mgr.getMetadataSearchPath());
        mgr.reset();
        TestOntDocumentManager.assertEquals((String)"file:foo.xml", (String)mgr.getMetadataSearchPath());
        TestOntDocumentManager.assertTrue((boolean)mgr.getCacheModels());
        mgr.setCacheModels(false);
        TestOntDocumentManager.assertFalse((boolean)mgr.getCacheModels());
        mgr.reset();
        TestOntDocumentManager.assertTrue((boolean)mgr.getCacheModels());
        TestOntDocumentManager.assertTrue((boolean)mgr.useDeclaredPrefixes());
        mgr.setUseDeclaredPrefixes(false);
        TestOntDocumentManager.assertFalse((boolean)mgr.useDeclaredPrefixes());
        mgr.reset();
        TestOntDocumentManager.assertTrue((boolean)mgr.useDeclaredPrefixes());
    }

    public void testDoAltMapping() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"file:vocabularies/owl.owl", (String)odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals((String)"http://example.com/nocache", (String)odm.doAltURLMapping("http://example.com/nocache"));
    }

    public void testGetLanguage() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)ProfileRegistry.OWL_LANG, (String)odm.getLanguage("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertNull((Object)odm.getLanguage("http://example.com/notthere"));
    }

    public void testGetPrefixForURI() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"owl", (String)odm.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        TestOntDocumentManager.assertNull((Object)odm.getPrefixForURI("http://example.com/notthere"));
    }

    public void testGetURIForPrefix() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"http://www.w3.org/2002/07/owl#", (String)odm.getURIForPrefix("owl"));
        TestOntDocumentManager.assertNull((Object)odm.getURIForPrefix("http://example.com/notthere"));
    }

    public void testAddModel0() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        Model m = ModelFactory.createDefaultModel();
        String uri = "http://example.com/test#m";
        TestOntDocumentManager.assertNull((Object)odm.getModel(uri));
        odm.addModel(uri, m);
        TestOntDocumentManager.assertSame((Object)m, (Object)odm.getModel(uri));
    }

    public void testAddModel1() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        Model m0 = ModelFactory.createDefaultModel();
        Model m1 = ModelFactory.createDefaultModel();
        String uri = "http://example.com/test#m";
        TestOntDocumentManager.assertNull((Object)odm.getModel(uri));
        odm.addModel(uri, m0);
        odm.addModel(uri, m1);
        TestOntDocumentManager.assertSame((Object)m0, (Object)odm.getModel(uri));
        odm.addModel(uri, m1, true);
        TestOntDocumentManager.assertSame((Object)m1, (Object)odm.getModel(uri));
    }

    public void testClearCache() {
        OntDocumentManager odm = OntDocumentManager.getInstance();
        Model m = ModelFactory.createDefaultModel();
        String uri = "http://example.com/test#m";
        TestOntDocumentManager.assertNull((Object)odm.getModel(uri));
        odm.addModel(uri, m);
        odm.clearCache();
        TestOntDocumentManager.assertSame(null, (Object)odm.getModel(uri));
    }

    public void testForget() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"file:vocabularies/owl.owl", (String)odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertEquals((String)"http://www.w3.org/2002/07/owl#", (String)odm.getLanguage("http://www.w3.org/2002/07/owl"));
        OntModel m = ModelFactory.createOntologyModel();
        odm.addModel("http://www.w3.org/2002/07/owl#", m);
        TestOntDocumentManager.assertNotNull((Object)odm.getModel("http://www.w3.org/2002/07/owl#"));
        odm.forget("http://www.w3.org/2002/07/owl#");
        odm.forget("http://www.w3.org/2002/07/owl");
        TestOntDocumentManager.assertEquals((String)"http://www.w3.org/2002/07/owl", (String)odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertNull((Object)odm.getLanguage("http://www.w3.org/2002/07/owl"));
        TestOntDocumentManager.assertNull((Object)odm.getModel("http://www.w3.org/2002/07/owl#"));
    }

    public void testGetOntology() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        OntModel m = odm.getOntology("http://www.w3.org/2002/07/owl", OntModelSpec.OWL_MEM);
        TestOntDocumentManager.assertNotNull((Object)m);
        TestOntDocumentManager.assertSame((Object)odm, (Object)m.getDocumentManager());
        OntModel m1 = odm.getOntology("http://www.w3.org/2002/07/owl", OntModelSpec.OWL_MEM);
        TestOntDocumentManager.assertSame((Object)m, (Object)m1);
    }

    public void testProcessImports() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue((boolean)odm.getProcessImports());
        odm.setProcessImports(false);
        TestOntDocumentManager.assertFalse((boolean)odm.getProcessImports());
    }

    public void testCacheModels() {
        OntDocumentManager odm = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertTrue((boolean)odm.getCacheModels());
        odm.setCacheModels(false);
        TestOntDocumentManager.assertFalse((boolean)odm.getCacheModels());
    }

    public void testManualAssociation() {
        OntDocumentManager odm = new OntDocumentManager((String)null);
        odm.addPrefixMapping("http://www.w3.org/2002/07/owl#", "owl");
        TestOntDocumentManager.assertEquals((String)"prefix for owl not correct", (String)"owl", (String)odm.getPrefixForURI("http://www.w3.org/2002/07/owl#"));
        TestOntDocumentManager.assertEquals((String)"URI for owl not correct", (String)"http://www.w3.org/2002/07/owl#", (String)odm.getURIForPrefix("owl"));
        odm.addAltEntry("http://www.w3.org/2002/07/owl", "file:foo.bar");
        TestOntDocumentManager.assertEquals((String)"Failed to retrieve cache location", (String)"file:foo.bar", (String)odm.doAltURLMapping("http://www.w3.org/2002/07/owl"));
        odm.addLanguageEntry("http://www.w3.org/2002/07/owl", "http://www.w3.org/2002/07/owl");
        TestOntDocumentManager.assertEquals((String)"Failed to retrieve language", (String)"http://www.w3.org/2002/07/owl", (String)odm.getLanguage("http://www.w3.org/2002/07/owl"));
    }

    public void testIgnoreImport() {
        OntDocumentManager odm = new OntDocumentManager();
        TestUtil.assertIteratorLength(odm.listIgnoredImports(), 0);
        odm.addIgnoreImport("file:testing/ontology/testImport3/c.owl");
        TestUtil.assertIteratorLength(odm.listIgnoredImports(), 1);
        TestOntDocumentManager.assertTrue((boolean)odm.ignoringImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((boolean)odm.ignoringImport("file:testing/ontology/foo.owl"));
        OntModelSpec spec = new OntModelSpec(null, odm, null, ProfileRegistry.OWL_LANG);
        OntModel m = ModelFactory.createOntologyModel(spec, null);
        TestOntDocumentManager.assertNotNull((String)"Ontology model should not be null", (Object)m);
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers(m));
        odm.removeIgnoreImport("file:testing/ontology/testImport3/c.owl");
        TestUtil.assertIteratorLength(odm.listIgnoredImports(), 0);
        TestOntDocumentManager.assertFalse((boolean)odm.ignoringImport("file:testing/ontology/testImport3/c.owl"));
    }

    public void testUnloadImport1() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        m.getDocumentManager().unloadImport(m, "file:testing/ontology/testImport3/c.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
    }

    public void testUnloadImport2() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.getDocumentManager().unloadImport(m, "file:testing/ontology/testImport3/b.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)1, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testUnloadImport3() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
        TestOntDocumentManager.assertTrue((String)"d should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        m.getDocumentManager().unloadImport(m, "file:testing/ontology/testImport6/b.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport6/c.owl"));
        TestOntDocumentManager.assertTrue((String)"d should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport6/d.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport6/b.owl"));
    }

    public void testDynamicImports1() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.add(a, m.getProfile().IMPORTS(), b);
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)0, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports2() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.setDynamicImports(true);
        m.add(a, m.getProfile().IMPORTS(), b);
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)2, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testDynamicImports3() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport3/a.owl");
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)3, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertTrue((String)"c should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertTrue((String)"b should be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.setDynamicImports(true);
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.remove(m.createStatement(a, m.getProfile().IMPORTS(), b));
        TestOntDocumentManager.assertEquals((String)"Marker count not correct", (int)1, (int)TestOntDocumentManager.countMarkers(m));
        TestOntDocumentManager.assertFalse((String)"c should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntDocumentManager.assertFalse((String)"b should not be imported", (boolean)m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testSearchPath() {
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"Did not return correct loaded search path", (String)"file:etc/ont-policy-test.rdf", (String)o1.getLoadedPolicyURL());
        OntDocumentManager o2 = new OntDocumentManager("file:etc/ont-policy-test.notexist.rdf;file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertEquals((String)"Did not return correct loaded search path", (String)"file:etc/ont-policy-test.rdf", (String)o2.getLoadedPolicyURL());
        OntDocumentManager o3 = new OntDocumentManager((String)null);
        TestOntDocumentManager.assertNull((String)"Most recent policy should be null", (Object)o3.getLoadedPolicyURL());
        o3.setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        TestOntDocumentManager.assertEquals((String)"Did not return correct loaded search path", (String)"file:etc/ont-policy-test.rdf", (String)o2.getLoadedPolicyURL());
        o3.setMetadataSearchPath("file:etc/ont-policy-test.notexist.rdf", true);
        TestOntDocumentManager.assertNull((String)"Most recent policy should be null", (Object)o3.getLoadedPolicyURL());
    }

    public void testReadFailHandler0() {
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestOntDocumentManager.assertNull((Object)o1.getReadFailureHandler());
        OntDocumentManager.ReadFailureHandler rfh = new OntDocumentManager.ReadFailureHandler(){

            public void handleFailedRead(String url, Model model, Exception e2) {
            }
        };
        o1.setReadFailureHandler(rfh);
        TestOntDocumentManager.assertSame((Object)rfh, (Object)o1.getReadFailureHandler());
    }

    public void testReadFailHandler1() {
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        TestFailHandler rfh = new TestFailHandler();
        o1.setReadFailureHandler(rfh);
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#> . <> a owl:Ontology ; owl:imports <http://example.com/not/exist>. ";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setDocumentManager(o1);
        OntModel m = ModelFactory.createOntologyModel(spec);
        m.read(new StringReader(source), "http://example.com/foo#", "N3");
        TestOntDocumentManager.assertTrue((boolean)rfh.m_seen);
    }

    public void testReadHook0() {
        TestReadHook rh = new TestReadHook(false);
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        o1.setReadHook(rh);
        o1.reset();
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#> . <> a owl:Ontology ; owl:imports <file:testing/ontology/testImport3/a.owl>. ";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setDocumentManager(o1);
        OntModel m = ModelFactory.createOntologyModel(spec);
        m.read(new StringReader(source), "http://example.com/foo#", "N3");
        TestOntDocumentManager.assertEquals((String)"Wrong number of calls to before load hook", (int)3, (int)rh.m_before);
        TestOntDocumentManager.assertEquals((String)"Wrong number of calls to before load hook", (int)3, (int)rh.m_after);
    }

    public void testReadHook1() {
        TestReadHook rh = new TestReadHook(true);
        OntDocumentManager o1 = new OntDocumentManager("file:etc/ont-policy-test.rdf");
        o1.setReadHook(rh);
        o1.reset();
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#> . <> a owl:Ontology ; owl:imports <file:testing/ontology/testImport3/a.owl>. ";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setDocumentManager(o1);
        OntModel m = ModelFactory.createOntologyModel(spec);
        m.read(new StringReader(source), "http://example.com/foo#", "N3");
        TestOntDocumentManager.assertEquals((String)"Wrong number of calls to before load hook", (int)1, (int)rh.m_before);
        TestOntDocumentManager.assertEquals((String)"Wrong number of calls to after load hook", (int)1, (int)rh.m_after);
    }

    public static int countMarkers(Model m) {
        int count = 0;
        Resource marker = m.getResource("http://jena.hpl.hp.com/2003/03/testont#Marker");
        StmtIterator i = m.listStatements(null, RDF.type, marker);
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    static class TestReadHook
    implements OntDocumentManager.ReadHook {
        private int m_before = 0;
        private int m_after = 0;
        private boolean m_renaming = false;

        TestReadHook(boolean renaming) {
            this.m_renaming = renaming;
        }

        public void afterRead(Model model, String source, OntDocumentManager odm) {
            ++this.m_after;
        }

        public String beforeRead(Model model, String source, OntDocumentManager odm) {
            if (this.m_renaming) {
                ++this.m_before;
                return "file:testing/ontology/testImport3/c.owl";
            }
            ++this.m_before;
            return source;
        }
    }

    static class TestFailHandler
    implements OntDocumentManager.ReadFailureHandler {
        public boolean m_seen = false;

        TestFailHandler() {
        }

        public void handleFailedRead(String url, Model model, Exception e2) {
            this.m_seen = true;
            log.debug("Seeing failed read of " + url, e2);
        }
    }

    static class DocManagerImportTest
    extends TestCase {
        String m_dir;
        int m_count;
        String m_path;
        boolean m_processImports;

        DocManagerImportTest(String dir, int count, boolean processImports, String path) {
            super(dir);
            this.m_dir = dir;
            this.m_count = count;
            this.m_path = path;
            this.m_processImports = processImports;
        }

        public void runTest() {
            OntDocumentManager dm = new OntDocumentManager();
            dm.setProcessImports(this.m_processImports);
            if (this.m_path != null) {
                dm.setMetadataSearchPath(this.m_path, true);
            }
            OntModelSpec spec = new OntModelSpec(null, dm, null, ProfileRegistry.OWL_LANG);
            OntModel m = ModelFactory.createOntologyModel(spec, null);
            DocManagerImportTest.assertNotNull((String)"Ontology model should not be null", (Object)m);
            m.read("file:" + this.m_dir + "/a.owl");
            DocManagerImportTest.assertEquals((String)"Marker count not correct", (int)this.m_count, (int)TestOntDocumentManager.countMarkers(m));
        }
    }
}

