/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states.test;

import com.hp.hpl.jena.rdf.arp.states.test.TestData;
import com.hp.hpl.jena.rdf.arp.states.test.TestEventList;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestARPStates
extends TestCase {
    public static TestSuite suite() {
        TestSuite rslt = new TestSuite();
        rslt.setName("ARP state machine");
        HashMap<String, TestSuite> tests = new HashMap<String, TestSuite>();
        try {
            LineNumberReader r = new LineNumberReader(new FileReader(TestData.dataFile));
            while (true) {
                String line;
                if ((line = r.readLine()) == null) {
                    return rslt;
                }
                int hash = line.indexOf(37);
                String[] fields = (line = (hash == -1 ? line : line.substring(0, hash)).trim()).split("  *");
                if (fields.length == 0) continue;
                TestSuite child = (TestSuite)tests.get(fields[0]);
                if (child == null) {
                    child = new TestSuite();
                    child.setName(TestData.stateLongName(fields[0]));
                    rslt.addTest((Test)child);
                    tests.put(fields[0], child);
                }
                child.addTest(TestEventList.create(line, fields));
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return rslt;
        }
    }
}

