/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

public class RecordingModelListener
implements ModelChangedListener {
    List history = new ArrayList();

    public void addedStatement(Statement s) {
        this.record("add", s);
    }

    public void addedStatements(Statement[] statements) {
        this.record("add[]", Arrays.asList(statements));
    }

    public void addedStatements(List statements) {
        this.record("addList", statements);
    }

    public void addedStatements(StmtIterator statements) {
        this.record("addIterator", ModelTestBase.iteratorToList(statements));
    }

    public void addedStatements(Model m) {
        this.record("addModel", m);
    }

    public void removedStatements(Statement[] statements) {
        this.record("remove[]", Arrays.asList(statements));
    }

    public void removedStatement(Statement s) {
        this.record("remove", s);
    }

    public void removedStatements(List statements) {
        this.record("removeList", statements);
    }

    public void removedStatements(StmtIterator statements) {
        this.record("removeIterator", ModelTestBase.iteratorToList(statements));
    }

    public void removedStatements(Model m) {
        this.record("removeModel", m);
    }

    public void notifyEvent(Model m, Object event) {
        this.record("someEvent", m, event);
    }

    protected void record(String tag, Object x, Object y) {
        this.history.add(tag);
        this.history.add(x);
        this.history.add(y);
    }

    protected void record(String tag, Object info) {
        this.history.add(tag);
        this.history.add(info);
    }

    public boolean has(Object[] things) {
        return ((Object)this.history).equals(Arrays.asList(things));
    }

    public void assertHas(Object[] things) {
        if (!this.has(things)) {
            ModelTestBase.fail((String)("expected " + Arrays.asList(things) + " but got " + this.history));
        }
    }

    public boolean has(List things) {
        return ((Object)this.history).equals(things);
    }

    public boolean hasStart(List L) {
        return L.size() <= this.history.size() && ((Object)L).equals(this.history.subList(0, L.size()));
    }

    public boolean hasEnd(List L) {
        return L.size() <= this.history.size() && ((Object)L).equals(this.history.subList(this.history.size() - L.size(), this.history.size()));
    }

    public void assertHas(List things) {
        if (!this.has(things)) {
            Assert.fail((String)("expected " + things + " but got " + this.history));
        }
    }

    public void assertHasStart(Object[] start) {
        List<Object> L = Arrays.asList(start);
        if (!this.hasStart(L)) {
            Assert.fail((String)("expected " + L + " at the beginning of " + this.history));
        }
    }

    public void assertHasEnd(Object[] end) {
        List<Object> L = Arrays.asList(end);
        if (!this.hasEnd(L)) {
            Assert.fail((String)("expected " + L + " at the end of " + this.history));
        }
    }

    public void clear() {
        this.history.clear();
    }
}

