/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.RecordingModelListener;
import java.io.StringReader;
import junit.framework.TestSuite;

public class TestReaderEvents
extends ModelTestBase {
    public TestReaderEvents(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReaderEvents.class);
    }

    public void testXMLReaderEvents() {
        String emptyModel = "<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'></rdf:RDF>";
        this.testReaderEvent("RDF/XML", emptyModel);
    }

    public void testN3ReaderEvents() {
        this.testReaderEvent("N3", "");
    }

    public void testNTriplesReaderEvents() {
        this.testReaderEvent("N-TRIPLE", "");
    }

    public void testReaderEvent(String language, String emptyModel) {
        Model m = ModelFactory.createDefaultModel();
        RecordingModelListener L = new RecordingModelListener();
        m.register(L);
        RDFReader r = m.getReader(language);
        StringReader stringReader = new StringReader(emptyModel);
        r.read(m, stringReader, "");
        L.assertHasStart(new Object[]{"someEvent", m, GraphEvents.startRead});
        L.assertHasEnd(new Object[]{"someEvent", m, GraphEvents.finishRead});
    }
}

