/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.FileManager;
import java.util.Iterator;
import junit.framework.TestCase;

public class OWLConsistencyTest
extends TestCase {
    public static final String BASE_DIR = "file:testing/reasoners/owl/";
    protected String tbox;
    protected String abox;
    protected int expected;
    protected ReasonerFactory rf;
    public static final int INCONSISTENT = 1;
    public static final int WARNINGS = 2;
    public static final int CLEAN = 3;
    protected Object culprit;

    public OWLConsistencyTest(String tbox, String abox, int expected, Object culprit) {
        super(abox);
        this.tbox = tbox;
        this.abox = abox;
        this.expected = expected;
        this.culprit = culprit;
    }

    public OWLConsistencyTest(OWLConsistencyTest base, String reasonerName, ReasonerFactory rf) {
        super(reasonerName + ":" + base.abox);
        this.tbox = base.tbox;
        this.abox = base.abox;
        this.expected = base.expected;
        this.culprit = base.culprit;
        this.rf = rf;
    }

    public void setReasonerFactory(ReasonerFactory rf) {
        this.rf = rf;
    }

    public ValidityReport testResults() {
        Model t = FileManager.get().loadModel(BASE_DIR + this.tbox);
        Model a = FileManager.get().loadModel(BASE_DIR + this.abox);
        Reasoner r = this.rf.create(null);
        a.add(t);
        InfModel im = ModelFactory.createInfModel(r, a);
        return im.validate();
    }

    public void runTest() {
        ValidityReport report = this.testResults();
        switch (this.expected) {
            case 1: {
                OWLConsistencyTest.assertTrue((String)"expected inconsistent", (!report.isValid() ? (byte)1 : 0) != 0);
                break;
            }
            case 2: {
                OWLConsistencyTest.assertTrue((String)"expected just warnings but reports not valid", (boolean)report.isValid());
                OWLConsistencyTest.assertFalse((String)"expected warnings but reports clean", (boolean)report.isClean());
                break;
            }
            case 3: {
                OWLConsistencyTest.assertTrue((String)"expected clean", (boolean)report.isClean());
            }
        }
        if (this.culprit != null) {
            boolean foundit = false;
            Iterator i = report.getReports();
            while (i.hasNext()) {
                ValidityReport.Report r = (ValidityReport.Report)i.next();
                if (r.getExtension() == null || !r.getExtension().equals(this.culprit)) continue;
                foundit = true;
                break;
            }
            if (!foundit) {
                OWLConsistencyTest.assertTrue((String)("Expcted to find a culprint " + this.culprit), (boolean)false);
            }
        }
    }
}

