/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TestGenericRuleReasonerConfig
extends AssemblerTestBase {
    public TestGenericRuleReasonerConfig(String name) {
        super(name);
    }

    protected Model setRequiredPrefixes(Model x) {
        x.setNsPrefix("jr", "http://jena.hpl.hp.com/2003/JenaReasoner#");
        return super.setRequiredPrefixes(x);
    }

    public void testLoadsSingleRuleSetViaURL() {
        this.testLoadsSingleRuleViaURL("jms");
        this.testLoadsSingleRuleViaURL("jr");
    }

    private void testLoadsSingleRuleViaURL(String ns) {
        String where = "file:testing/modelspecs/example.rules";
        Resource r = this.resourceInModel("x <ns>:ruleSetURL <where>".replaceAll("<ns>", ns).replaceAll("<where>", where));
        List rules = Rule.rulesFromURL(where);
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals((Object)rules, (Object)grr.getRules());
    }

    public void testLoadsSingleRuleFromString() {
        this.testLoadsSingleRuleFromString("jms");
        this.testLoadsSingleRuleFromString("jr");
    }

    private void testLoadsSingleRuleFromString(String ns) {
        String rule = "[R: (?x rdf:type eg:Thing) -> (?x eg:thing true)]";
        List rules = Rule.parseRules(rule);
        Resource r = this.resourceInModel("x <ns>:hasRule '<it>'".replaceAll("<ns>", ns).replaceAll("<it>", rule.replaceAll(" ", "\\\\\\\\s")));
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals((Object)rules, (Object)grr.getRules());
    }

    public void testLoadsSingleRuleViaRuleSetStringString() {
        this.testLoadsRulesViaRuleSetStrings("jms");
        this.testLoadsRulesViaRuleSetStrings("jr");
    }

    private void testLoadsRulesViaRuleSetStrings(String ns) {
        String ruleA = "[R: (?x rdf:type eg:Thing) -> (?x eg:thing true)]";
        String ruleB = "[S: (?x rdf:type eg:Thung) -> (?x eg:thing false)]";
        Set rules = this.rulesFromTwoStrings(ruleA, ruleB);
        String modelString = "x <ns>:ruleSet _x; _x <ns>:hasRule '<A>'; _x <ns>:hasRule '<B>'".replaceAll("<ns>", ns).replaceAll("<A>", ruleA.replaceAll(" ", "\\\\\\\\s")).replaceAll("<B>", ruleB.replaceAll(" ", "\\\\\\\\s"));
        Resource r = this.resourceInModel(modelString);
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals((Object)rules, new HashSet(grr.getRules()));
    }

    public void testLoadsMultipleRuleSetsViaRuleSetNode() {
        this.testLoadsMultipleRuleSetsViaRuleSetNode("jms");
        this.testLoadsMultipleRuleSetsViaRuleSetNode("jr");
    }

    private void testLoadsMultipleRuleSetsViaRuleSetNode(String ns) {
        String whereA = "file:testing/modelspecs/example.rules";
        String whereB = "file:testing/modelspecs/extra.rules";
        Resource r = this.resourceInModel("x <ns>:ruleSet _a; _a <ns>:ruleSetURL <whereA>; _a <ns>:ruleSetURL <whereB>".replaceAll("<ns>", ns).replaceAll("<whereA>", whereA).replaceAll("<whereB>", whereB));
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals((Object)this.rulesFromTwoPlaces(whereA, whereB), new HashSet(grr.getRules()));
    }

    private Set rulesFromTwoStrings(String ruleA, String ruleB) {
        HashSet rules = new HashSet(Rule.parseRules(ruleA));
        rules.addAll(Rule.parseRules(ruleB));
        return rules;
    }

    private Set rulesFromTwoPlaces(String whereA, String whereB) {
        HashSet rules = new HashSet();
        rules.addAll(Rule.rulesFromURL(whereA));
        rules.addAll(Rule.rulesFromURL(whereB));
        return rules;
    }
}

