/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionSeq
extends NewRegressionBase {
    protected Model m;

    public NewRegressionSeq(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionSeq.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void testSeqAdd() {
        Seq seq2 = this.m.createSeq();
        NewRegressionSeq.assertEquals((int)0, (int)seq2.size());
        NewRegressionSeq.assertTrue((boolean)this.m.contains((Resource)seq2, RDF.type, RDF.Seq));
        seq2.add(true);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(true));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(false));
        seq2.add(1L);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(1L));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(101L));
        seq2.add(2L);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(2L));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(102L));
        seq2.add(-1L);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(-1L));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(-101L));
        seq2.add(-2L);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(-2L));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(-102L));
        seq2.add('!');
        NewRegressionSeq.assertTrue((boolean)seq2.contains('!'));
        NewRegressionSeq.assertFalse((boolean)seq2.contains('?'));
        seq2.add(123.456f);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(123.456f));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(456.123f));
        seq2.add(-123.456);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(-123.456));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(-456.123));
        seq2.add("a string");
        NewRegressionSeq.assertTrue((boolean)seq2.contains("a string"));
        NewRegressionSeq.assertFalse((boolean)seq2.contains("a necklace"));
        seq2.add(this.m.createLiteral("another string"));
        NewRegressionSeq.assertTrue((boolean)seq2.contains("another string"));
        NewRegressionSeq.assertFalse((boolean)seq2.contains("another necklace"));
        seq2.add(new Regression.LitTestObj(12345L));
        NewRegressionSeq.assertTrue((boolean)seq2.contains(new Regression.LitTestObj(12345L)));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(new Regression.LitTestObj(54321L)));
        Resource present = this.m.createResource(new Regression.ResTestObjF());
        Resource absent = this.m.createResource(new Regression.ResTestObjF());
        seq2.add(present);
        NewRegressionSeq.assertTrue((boolean)seq2.contains(present));
        NewRegressionSeq.assertFalse((boolean)seq2.contains(absent));
        NewRegressionSeq.assertEquals((int)12, (int)seq2.size());
    }

    public void testSeqAddInts() {
        int num = 10;
        Seq seq2 = this.m.createSeq();
        for (int i = 0; i < 10; ++i) {
            seq2.add(i);
        }
        NewRegressionSeq.assertEquals((int)10, (int)seq2.size());
        List L = NewRegressionSeq.iteratorToList(seq2.iterator());
        NewRegressionSeq.assertEquals((int)10, (int)L.size());
        for (int i = 0; i < 10; ++i) {
            NewRegressionSeq.assertEquals((int)i, (int)((Literal)L.get(i)).getInt());
        }
    }

    public void testRemoveA() {
        this.testRemove(this.bools("tttffffftt"));
    }

    public void testRemoveB() {
        this.testRemove(this.bools("ftftttttft"));
    }

    public void testRemoveC() {
        this.testRemove(this.bools("ffffffffff"));
    }

    protected boolean[] bools(String s) {
        boolean[] result = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            result[i] = s.charAt(i) == 't';
        }
        return result;
    }

    protected void testRemove(boolean[] retain) {
        int num = retain.length;
        Seq seq2 = this.m.createSeq();
        for (int i = 0; i < num; ++i) {
            seq2.add(i);
        }
        ArrayList<RDFNode> retained = new ArrayList<RDFNode>();
        NodeIterator nIter = seq2.iterator();
        for (int i = 0; i < num; ++i) {
            RDFNode x = nIter.nextNode();
            if (retain[i]) {
                retained.add(x);
                continue;
            }
            nIter.remove();
        }
        NewRegressionSeq.assertFalse((boolean)nIter.hasNext());
        NewRegressionSeq.assertEquals(retained, (Object)NewRegressionSeq.iteratorToList(seq2.iterator()));
    }

    public void testSeqAccessByIndexing() {
        Regression.LitTestObj tvObject = new Regression.LitTestObj(12345L);
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResource = this.m.createResource();
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Seq seq2 = this.m.createSeq();
        seq2.add(true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq2.getBoolean(1));
        seq2.add(1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq2.getByte(2));
        seq2.add(2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq2.getShort(3));
        seq2.add(-1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq2.getInt(4));
        seq2.add(-2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq2.getLong(5));
        seq2.add('!');
        NewRegressionSeq.assertEquals((char)'!', (char)seq2.getChar(6));
        seq2.add(123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq2.getFloat(7), (double)5.0E-5);
        seq2.add(12345.6789);
        NewRegressionSeq.assertEquals((double)12345.6789, (double)seq2.getDouble(8), (double)5.0E-8);
        seq2.add("some string");
        NewRegressionSeq.assertEquals((String)"some string", (String)seq2.getString(9));
        seq2.add(tvLitObj);
        NewRegressionSeq.assertEquals((Object)tvLitObj, (Object)seq2.getObject(10, new Regression.LitTestObjF()));
        seq2.add(tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq2.getResource(11));
        seq2.add(tvResObj);
        NewRegressionSeq.assertEquals((Object)tvResObj, (Object)seq2.getResource(12, new Regression.ResTestObjF()));
        seq2.add(tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq2.getLiteral(13));
        seq2.add(tvBag);
        NewRegressionSeq.assertEquals((Object)tvBag, (Object)seq2.getBag(14));
        seq2.add(tvAlt);
        NewRegressionSeq.assertEquals((Object)tvAlt, (Object)seq2.getAlt(15));
        seq2.add(tvSeq);
        NewRegressionSeq.assertEquals((Object)tvSeq, (Object)seq2.getSeq(16));
        try {
            seq2.getInt(17);
            NewRegressionSeq.fail((String)"there is no element 17");
        }
        catch (SeqIndexBoundsException e2) {
            NewRegressionSeq.pass();
        }
        try {
            seq2.getInt(0);
            NewRegressionSeq.fail((String)"there is no element 0");
        }
        catch (SeqIndexBoundsException e3) {
            NewRegressionSeq.pass();
        }
    }

    public void testSeqInsertByIndexing() {
        Regression.LitTestObj tvObject = new Regression.LitTestObj(12345L);
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResource = this.m.createResource();
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Seq seq2 = this.m.createSeq();
        seq2.add(this.m.createResource());
        seq2.add(1, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq2.getBoolean(1));
        seq2.add(1, 1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq2.getByte(1));
        seq2.add(1, 2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq2.getShort(1));
        seq2.add(1, -1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq2.getInt(1));
        seq2.add(1, -2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq2.getLong(1));
        seq2.add(1, '!');
        NewRegressionSeq.assertEquals((char)'!', (char)seq2.getChar(1));
        seq2.add(1, 123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq2.getFloat(1), (double)5.0E-5);
        seq2.add(1, 12345.6789);
        NewRegressionSeq.assertEquals((double)12345.6789, (double)seq2.getDouble(1), (double)5.0E-8);
        seq2.add(1, "some string");
        NewRegressionSeq.assertEquals((String)"some string", (String)seq2.getString(1));
        seq2.add(1, tvLitObj);
        NewRegressionSeq.assertEquals((Object)tvLitObj, (Object)seq2.getObject(1, new Regression.LitTestObjF()));
        seq2.add(1, tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq2.getResource(1));
        seq2.add(1, tvResObj);
        NewRegressionSeq.assertEquals((Object)tvResObj, (Object)seq2.getResource(1, new Regression.ResTestObjF()));
        seq2.add(1, tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq2.getLiteral(1));
        seq2.add(1, tvBag);
        NewRegressionSeq.assertEquals((Object)tvBag, (Object)seq2.getBag(1));
        seq2.add(1, tvAlt);
        NewRegressionSeq.assertEquals((Object)tvAlt, (Object)seq2.getAlt(1));
        seq2.add(1, tvSeq);
        NewRegressionSeq.assertEquals((Object)tvSeq, (Object)seq2.getSeq(1));
        NewRegressionSeq.assertEquals((int)0, (int)seq2.indexOf(1234543L));
        NewRegressionSeq.assertEquals((int)1, (int)seq2.indexOf(tvSeq));
        NewRegressionSeq.assertEquals((int)2, (int)seq2.indexOf(tvAlt));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.indexOf(tvBag));
        NewRegressionSeq.assertEquals((int)4, (int)seq2.indexOf(tvLiteral));
        NewRegressionSeq.assertEquals((int)6, (int)seq2.indexOf(tvResource));
        NewRegressionSeq.assertEquals((int)7, (int)seq2.indexOf(tvLitObj));
        NewRegressionSeq.assertEquals((int)8, (int)seq2.indexOf("some string"));
        NewRegressionSeq.assertEquals((int)9, (int)seq2.indexOf(12345.6789));
        NewRegressionSeq.assertEquals((int)10, (int)seq2.indexOf(123.456f));
        NewRegressionSeq.assertEquals((int)11, (int)seq2.indexOf('!'));
        NewRegressionSeq.assertEquals((int)12, (int)seq2.indexOf(-2L));
        NewRegressionSeq.assertEquals((int)13, (int)seq2.indexOf(-1L));
        NewRegressionSeq.assertEquals((int)14, (int)seq2.indexOf(2L));
        NewRegressionSeq.assertEquals((int)15, (int)seq2.indexOf(1L));
        NewRegressionSeq.assertEquals((int)16, (int)seq2.indexOf(true));
    }

    public void testMoreIndexing() {
        int num = 10;
        Seq seq2 = this.m.createSeq();
        for (int i = 0; i < 10; ++i) {
            seq2.add(i);
        }
        try {
            seq2.add(0, false);
            NewRegressionSeq.fail((String)"cannot at at position 0");
        }
        catch (SeqIndexBoundsException e2) {
            NewRegressionSeq.pass();
        }
        seq2.add(11, false);
        NewRegressionSeq.assertEquals((int)11, (int)seq2.size());
        seq2.remove(11);
        try {
            seq2.add(12, false);
            NewRegressionSeq.fail((String)"cannot add past the end");
        }
        catch (SeqIndexBoundsException e3) {
            NewRegressionSeq.pass();
        }
        int size = seq2.size();
        for (int i = 1; i <= 9; ++i) {
            seq2.add(i, 1000 + i);
            NewRegressionSeq.assertEquals((int)(1000 + i), (int)seq2.getInt(i));
            NewRegressionSeq.assertEquals((int)0, (int)seq2.getInt(i + 1));
            NewRegressionSeq.assertEquals((int)(size + i), (int)seq2.size());
            NewRegressionSeq.assertEquals((int)(10 - i - 1), (int)seq2.getInt(size));
        }
    }

    public void testSet() {
        Model m = this.getModel();
        String test = "Test16";
        boolean n = false;
        Literal tvLiteral = m.createLiteral("test 12 string 2");
        Resource tvResource = m.createResource();
        Resource tvResObj = m.createResource(new Regression.ResTestObjF());
        Bag tvBag = m.createBag();
        Alt tvAlt = m.createAlt();
        Seq tvSeq = m.createSeq();
        int num = 10;
        Seq seq2 = m.createSeq();
        for (int i = 0; i < num; ++i) {
            seq2.add(i);
        }
        seq2.set(5, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq2.getBoolean(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, 1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq2.getByte(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, 2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq2.getShort(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, -1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq2.getInt(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, -2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq2.getLong(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, "test 12 string");
        NewRegressionSeq.assertEquals((String)"test 12 string", (String)seq2.getString(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq2.getBoolean(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, 123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq2.getFloat(5), (double)5.0E-5);
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, -123.456);
        NewRegressionSeq.assertEquals((double)-123.456, (double)seq2.getDouble(5), (double)5.0E-9);
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq2.getLiteral(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq2.getResource(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, tvLitObj);
        NewRegressionSeq.assertEquals((Object)tvLitObj, (Object)seq2.getObject(5, new Regression.LitTestObjF()));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
        seq2.set(5, tvResObj);
        NewRegressionSeq.assertEquals((Object)tvResObj, (Object)seq2.getResource(5, new Regression.ResTestObjF()));
        NewRegressionSeq.assertEquals((int)3, (int)seq2.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq2.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq2.size());
    }
}

