/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid.test;

import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.UUIDFactory;
import com.hp.hpl.jena.shared.uuid.UUID_V1;
import com.hp.hpl.jena.shared.uuid.UUID_V1_Gen;
import com.hp.hpl.jena.shared.uuid.UUID_V4_Gen;
import com.hp.hpl.jena.shared.uuid.UUID_nil;
import junit.framework.TestCase;

public class TestUUID
extends TestCase {
    UUIDFactory randomFactory = new UUID_V4_Gen();

    public void testNilUUID1() {
        JenaUUID u = JenaUUID.nil();
        TestUUID.assertTrue((u.getVariant() == 0 ? (byte)1 : 0) != 0);
        TestUUID.assertTrue((u.getVersion() == 0 ? (byte)1 : 0) != 0);
        TestUUID.assertTrue((u == UUID_nil.getNil() ? (byte)1 : 0) != 0);
    }

    public void testNilUUID2() {
        JenaUUID u = JenaUUID.nil();
        TestUUID.assertTrue((boolean)u.isNil());
    }

    public void testNilUUID3() {
        JenaUUID u = JenaUUID.nil();
        String s = u.asString();
        TestUUID.assertEquals((String)s, (String)UUID_nil.getNilString());
    }

    public void testTime1() {
        JenaUUID u = JenaUUID.generate();
        TestUUID.assertTrue((u.getVersion() == 1 ? (byte)1 : 0) != 0);
        TestUUID.assertTrue((u.getVariant() == 2 ? (byte)1 : 0) != 0);
    }

    public void testTime2() {
        JenaUUID u = JenaUUID.generate();
        this.check(u);
    }

    public void testTime3() {
        UUID_V1 u1 = new UUID_V1_Gen().generateV1();
        UUID_V1 u2 = UUID_V1_Gen.generate(u1.getVersion(), u1.getVariant(), u1.getTimestamp(), u1.getClockSequence(), u1.getNode());
        TestUUID.assertEquals((int)u1.getVersion(), (int)u2.getVersion());
        TestUUID.assertEquals((int)u1.getVariant(), (int)u2.getVariant());
        TestUUID.assertEquals((long)u1.getTimestamp(), (long)u2.getTimestamp());
        TestUUID.assertEquals((long)u1.getClockSequence(), (long)u2.getClockSequence());
        TestUUID.assertEquals((long)u1.getNode(), (long)u2.getNode());
    }

    public void testTime4() {
        UUID_V1 u1 = new UUID_V1_Gen().generateV1();
        UUID_V1 u2 = UUID_V1_Gen.generate(u1.getVersion(), u1.getVariant(), u1.getTimestamp(), u1.getClockSequence(), u1.getNode());
        TestUUID.assertEquals((Object)u1, (Object)u2);
        TestUUID.assertEquals((String)u1.asString(), (String)u2.asString());
    }

    public void testTime5() {
        UUID_V1 u1 = new UUID_V1_Gen().generateV1();
        UUID_V1 u2 = UUID_V1_Gen.generate(u1.getVersion(), u1.getVariant(), u1.getTimestamp(), u1.getClockSequence(), u1.getNode());
        TestUUID.assertEquals((String)u1.asString(), (String)u2.asString());
    }

    public void testTime6() {
        JenaUUID u1 = JenaUUID.generate();
        JenaUUID u2 = JenaUUID.generate();
        TestUUID.assertFalse((boolean)u1.equals(u2));
    }

    public void testRandom1() {
        JenaUUID u = this.randomFactory.generate();
        TestUUID.assertEquals((int)u.getVersion(), (int)4);
        TestUUID.assertEquals((int)u.getVariant(), (int)2);
    }

    public void testRandom2() {
        JenaUUID u = this.randomFactory.generate();
        this.check(u);
    }

    public void testRandom3() {
        JenaUUID u = this.randomFactory.generate();
        this.check(u.asString());
    }

    public void testRandom4() {
        JenaUUID u1 = this.randomFactory.generate();
        JenaUUID u2 = this.randomFactory.generate();
        TestUUID.assertFalse((boolean)u1.equals(u2));
    }

    public void testEquals1() {
        JenaUUID u1 = JenaUUID.generate();
        JenaUUID u2 = JenaUUID.parse(u1.asString());
        TestUUID.assertNotSame((Object)u1, (Object)u2);
        TestUUID.assertEquals((Object)u1, (Object)u2);
        JenaUUID u3 = JenaUUID.generate();
        TestUUID.assertFalse((boolean)u1.equals(u3));
        TestUUID.assertFalse((boolean)u3.equals(u1));
        TestUUID.assertFalse((boolean)u2.equals(u3));
        TestUUID.assertFalse((boolean)u3.equals(u2));
    }

    public void testEquals2() {
        JenaUUID u1 = this.randomFactory.generate();
        JenaUUID u2 = JenaUUID.parse(u1.asString());
        TestUUID.assertNotSame((Object)u1, (Object)u2);
        TestUUID.assertEquals((Object)u1, (Object)u2);
        JenaUUID u3 = this.randomFactory.generate();
        TestUUID.assertFalse((boolean)u1.equals(u3));
        TestUUID.assertFalse((boolean)u3.equals(u1));
        TestUUID.assertFalse((boolean)u2.equals(u3));
        TestUUID.assertFalse((boolean)u3.equals(u2));
    }

    public void testHash1() {
        JenaUUID u1 = JenaUUID.generate();
        JenaUUID u2 = JenaUUID.parse(u1.asString());
        TestUUID.assertNotSame((Object)u1, (Object)u2);
        TestUUID.assertEquals((int)u1.hashCode(), (int)u2.hashCode());
        JenaUUID u3 = JenaUUID.generate();
        TestUUID.assertFalse((u1.hashCode() == u3.hashCode() ? (byte)1 : 0) != 0);
    }

    public void testHash2() {
        JenaUUID u1 = this.randomFactory.generate();
        JenaUUID u2 = JenaUUID.parse(u1.asString());
        TestUUID.assertNotSame((Object)u1, (Object)u2);
        TestUUID.assertEquals((int)u1.hashCode(), (int)u2.hashCode());
    }

    public void testMisc1() {
        this.check("8609C81E-EE1F-4D5A-B202-3EB13AD01823");
        this.check("uuid:DB77450D-9FA8-45D4-A7BC-04411D14E384");
        this.check("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2");
        this.check("urn:8609C81E-EE1F-4D5A-B202-3EB13AD01823");
        this.check("urn:uuid:70A80F61-77BC-4821-A5E2-2A406ACC35DD");
    }

    private void check(String uuidString) {
        JenaUUID uuid = JenaUUID.parse(uuidString);
        String s2 = uuid.asString();
        String s = uuidString;
        if (s.matches("[uU][rR][nN]:")) {
            s = s.substring(4);
        }
        if (s.startsWith("[uU][uU][iI][dD]:")) {
            s = s.substring(5);
        }
        TestUUID.assertTrue((boolean)uuidString.equalsIgnoreCase(s));
    }

    private void check(JenaUUID uuid) {
        String s = uuid.asString();
        if (uuid.isNil()) {
            TestUUID.assertEquals((String)JenaUUID.strNil(), (String)s);
            return;
        }
        JenaUUID uuid2 = JenaUUID.parse(s);
        TestUUID.assertTrue((boolean)uuid2.equals(uuid));
    }
}

