/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;

public class QueryIterTriplePattern
extends QueryIterRepeatApply {
    Triple pattern;
    static int countMapper = 0;

    public QueryIterTriplePattern(QueryIterator input, Triple pattern, ExecutionContext cxt) {
        super(input, cxt);
        this.pattern = pattern;
    }

    protected QueryIterator nextStage(Binding binding) {
        return new TripleMapper(binding, this.pattern, this.getExecContext());
    }

    static class TripleMapper
    extends QueryIter {
        private Node s;
        private Node p;
        private Node o;
        private Binding binding;
        private ClosableIterator graphIter;
        private Binding slot = null;

        TripleMapper(Binding binding, Triple pattern, ExecutionContext cxt) {
            super(cxt);
            this.s = this.substitute(pattern.getSubject(), binding);
            this.p = this.substitute(pattern.getPredicate(), binding);
            this.o = this.substitute(pattern.getObject(), binding);
            this.binding = binding;
            Node s2 = this.tripleNode(this.s);
            Node p2 = this.tripleNode(this.p);
            Node o2 = this.tripleNode(this.o);
            Graph graph = cxt.getActiveGraph();
            ExtendedIterator iter = graph.find(s2, p2, o2);
            this.graphIter = iter;
        }

        private Node tripleNode(Node node) {
            if (node.isVariable()) {
                return Node.ANY;
            }
            return node;
        }

        private Node substitute(Node node, Binding binding) {
            Node x;
            if (Var.isVar(node) && (x = binding.get(Var.alloc(node))) != null) {
                return x;
            }
            return node;
        }

        private Binding mapper(Triple r) {
            BindingMap results = new BindingMap(this.binding);
            if (!TripleMapper.insert(this.s, r.getSubject(), results)) {
                return null;
            }
            if (!TripleMapper.insert(this.p, r.getPredicate(), results)) {
                return null;
            }
            if (!TripleMapper.insert(this.o, r.getObject(), results)) {
                return null;
            }
            return results;
        }

        private static boolean insert(Node inputNode, Node outputNode, Binding results) {
            if (!Var.isVar(inputNode)) {
                return true;
            }
            Var v = Var.alloc(inputNode);
            Node x = results.get(v);
            if (x != null) {
                return outputNode.equals(x);
            }
            results.add(v, outputNode);
            return true;
        }

        private Binding _mapper(Triple r) {
            BindingMap results = new BindingMap(this.binding);
            int z = 0;
            int x = TripleMapper._insert(this.s, r.getSubject(), results);
            if (x == -1) {
                return null;
            }
            z += x;
            x = TripleMapper._insert(this.p, r.getPredicate(), results);
            if (x == -1) {
                return null;
            }
            z += x;
            x = TripleMapper._insert(this.o, r.getObject(), results);
            if (x == -1) {
                return null;
            }
            if ((z += x) == 0) {
                return this.binding;
            }
            return results;
        }

        private static int _insert(Node inputNode, Node outputNode, Binding results) {
            if (!Var.isVar(inputNode)) {
                return 0;
            }
            Var v = Var.alloc(inputNode);
            Node x = results.get(v);
            if (x != null) {
                return outputNode.equals(x) ? 0 : -1;
            }
            results.add(v, outputNode);
            return 1;
        }

        protected boolean hasNextBinding() {
            if (this.slot != null) {
                return true;
            }
            while (this.graphIter.hasNext() && this.slot == null) {
                Triple t = (Triple)this.graphIter.next();
                this.slot = this.mapper(t);
            }
            return this.slot != null;
        }

        protected Binding moveToNextBinding() {
            this.hasNextBinding();
            Binding r = this.slot;
            this.slot = null;
            return r;
        }

        protected void closeIterator() {
            if (this.graphIter != null) {
                NiceIterator.close(this.graphIter);
            }
            this.graphIter = null;
        }
    }
}

