/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Histogram;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Pattern;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndex
extends TestCase {
    private static Model graphM = null;
    private static ProbabilityIndex index = null;
    private static ProbabilityIndexModel probability = null;
    private static Map properties = null;
    private static Map histograms = null;
    private static Map patterns = null;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestIndex(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(Util.readModel(testDataFileName));
        index = probability.getIndex();
        properties = index.getProperties();
        histograms = index.getHistograms();
        patterns = index.getPatterns();
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testDataGraphSize() {
        TestIndex.assertEquals((long)probability.getDataGraphSize(), (long)37L);
    }

    public void testIndexedSize() {
        TestIndex.assertEquals((long)probability.getIndexedSize(), (long)37L);
    }

    public void testMinProbability() {
        TestIndex.assertEquals((double)probability.getMinProbability(), (double)0.02702702702702703, (double)0.0);
    }

    public void testMinJoinedProbability() {
        TestIndex.assertEquals((double)probability.getMinJoinedProbability(), (double)7.304601899196494E-4, (double)0.0);
    }

    public void testSquaredDataGraphSize() {
        TestIndex.assertEquals((double)probability.getSquaredDataGraphSize(), (double)1369.0, (double)0.0);
    }

    public void testSquaredIndexedSize() {
        TestIndex.assertEquals((double)probability.getSquaredIndexedSize(), (double)1369.0, (double)0.0);
    }

    public void testIndexAllowsJoinedProbability() {
        TestIndex.assertTrue((index.allowsJoinedProbability() ? (byte)1 : 0) != 0);
    }

    public void testIndexLevel() {
        TestIndex.assertEquals((int)index.getLevel(), (int)1);
    }

    public void testNumOfIndexedResources() {
        TestIndex.assertEquals((long)index.getIndexedNumRes(), (long)5L);
    }

    public void testIndexedSSSize() {
        TestIndex.assertEquals((long)index.getIndexedSSSize(), (long)303L);
    }

    public void testIndexedSOSize() {
        TestIndex.assertEquals((long)index.getIndexedSOSize(), (long)0L);
    }

    public void testIndexedOSSize() {
        TestIndex.assertEquals((long)index.getIndexedOSSize(), (long)0L);
    }

    public void testIndexedOOSize() {
        TestIndex.assertEquals((long)index.getIndexedOOSize(), (long)63L);
    }

    public void testNumOfIndexedProperties() {
        TestIndex.assertEquals((int)properties.size(), (int)9);
    }

    public void testPropertyLookup1() {
        Property property = ResourceFactory.createProperty("http://example.org#firstname");
        TestIndex.assertEquals((long)((Long)properties.get(property)), (long)5L);
        TestIndex.assertEquals((long)index.lookup(property), (long)5L);
    }

    public void testPropertyLookup2() {
        Property property = ResourceFactory.createProperty("http://example.org#lastname");
        TestIndex.assertEquals((long)((Long)properties.get(property)), (long)5L);
        TestIndex.assertEquals((long)index.lookup(property), (long)5L);
    }

    public void testPropertyLookup3() {
        Property property = ResourceFactory.createProperty("http://example.org#msn");
        TestIndex.assertEquals((long)((Long)properties.get(property)), (long)3L);
        TestIndex.assertEquals((long)index.lookup(property), (long)3L);
    }

    public void testPropertyLookup4() {
        Property property = ResourceFactory.createProperty("http://example.org#skype");
        TestIndex.assertEquals((long)((Long)properties.get(property)), (long)4L);
        TestIndex.assertEquals((long)index.lookup(property), (long)4L);
    }

    public void testPropertyLookup5() {
        Property property = ResourceFactory.createProperty("http://example.org#Workplace");
        TestIndex.assertEquals((long)index.lookup(property), (long)0L);
    }

    public void testNumOfIndexedHistograms() {
        TestIndex.assertEquals((int)histograms.size(), (int)properties.size());
    }

    public void testHistogram1() {
        Property property = ResourceFactory.createProperty("http://example.org#firstname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.size(), (long)5L);
        TestIndex.assertEquals((double)histogram.getClassSize(), (double)0.4, (double)0.0);
        TestIndex.assertEquals((double)histogram.getLowerBound(), (double)-9.18128756E8, (double)0.0);
        TestIndex.assertEquals((double)histogram.getUpperBound(), (double)-9.18128752E8, (double)0.0);
        TestIndex.assertEquals((int)histogram.getClasses().size(), (int)10);
    }

    public void testHistogram2() {
        Property property = ResourceFactory.createProperty("http://example.org#lastname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.size(), (long)5L);
        TestIndex.assertEquals((double)histogram.getClassSize(), (double)0.4, (double)0.0);
        TestIndex.assertEquals((double)histogram.getLowerBound(), (double)-1.746240346E9, (double)0.0);
        TestIndex.assertEquals((double)histogram.getUpperBound(), (double)-1.746240342E9, (double)0.0);
        TestIndex.assertEquals((int)histogram.getClasses().size(), (int)10);
    }

    public void testHistogram3() {
        Property property = ResourceFactory.createProperty("http://example.org#msn");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.size(), (long)3L);
        TestIndex.assertEquals((double)histogram.getClassSize(), (double)2.487512833E8, (double)0.0);
        TestIndex.assertEquals((double)histogram.getLowerBound(), (double)-5.9668676E8, (double)0.0);
        TestIndex.assertEquals((double)histogram.getUpperBound(), (double)1.890826073E9, (double)0.0);
        TestIndex.assertEquals((int)histogram.getClasses().size(), (int)10);
    }

    public void testHistogram4() {
        Property property = ResourceFactory.createProperty("http://example.org#skype");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.size(), (long)4L);
        TestIndex.assertEquals((double)histogram.getClassSize(), (double)1.121603817E8, (double)0.0);
        TestIndex.assertEquals((double)histogram.getLowerBound(), (double)-6.78441091E8, (double)0.0);
        TestIndex.assertEquals((double)histogram.getUpperBound(), (double)4.43162726E8, (double)0.0);
        TestIndex.assertEquals((int)histogram.getClasses().size(), (int)10);
    }

    public void testHistogramClass1() {
        Property property = ResourceFactory.createProperty("http://example.org#firstname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("First Name 1")), (long)1L);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("First Name 2")), (long)1L);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("First Name 10")), (long)0L);
    }

    public void testHistogramClass2() {
        Property property = ResourceFactory.createProperty("http://example.org#lastname");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("Last Name 1")), (long)1L);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("Last Name 2")), (long)1L);
    }

    public void testHistogramClass3() {
        Property property = ResourceFactory.createProperty("http://example.org#phone");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("xxx-xxx-xxx")), (long)5L);
    }

    public void testHistogramClass4() {
        Property property = ResourceFactory.createProperty("http://example.org#workplace");
        Histogram histogram = (Histogram)histograms.get(property);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("company1")), (long)2L);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("company3")), (long)1L);
        TestIndex.assertEquals((long)histogram.getClassFrequency(Node.createLiteral("company10")), (long)0L);
    }

    public void testNumOfIndexedPatterns() {
        TestIndex.assertEquals((int)patterns.size(), (int)(properties.size() * properties.size() * 4));
    }

    public void testPattern1() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#phone");
        Property joinedP = ResourceFactory.createProperty("http://example.org#phone");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#OO");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((long)((Long)patterns.get(pattern)), (long)25L);
    }

    public void testPattern2() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#email");
        Property joinedP = ResourceFactory.createProperty("http://example.org#skype");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#SS");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((long)((Long)patterns.get(pattern)), (long)4L);
    }

    public void testPattern3() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#skype");
        Property joinedP = ResourceFactory.createProperty("http://example.org#skype");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#SS");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((long)((Long)patterns.get(pattern)), (long)6L);
    }

    public void testPattern4() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#firstname");
        Property joinedP = ResourceFactory.createProperty("http://example.org#skype");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#SO");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((long)((Long)patterns.get(pattern)), (long)0L);
    }

    public void testPattern5() {
        Property joiningP = ResourceFactory.createProperty("http://example.org#workplace");
        Property joinedP = ResourceFactory.createProperty("http://example.org#workplace");
        Resource joinT = ResourceFactory.createResource("http://jena.hpl.hp.com/ARQo/join#OO");
        Pattern pattern = new Pattern(joiningP, joinedP, joinT);
        TestIndex.assertEquals((long)((Long)patterns.get(pattern)), (long)9L);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestIndex");
        ts.addTest((Test)new TestIndex("testDataGraphSize"));
        ts.addTest((Test)new TestIndex("testIndexedSize"));
        ts.addTest((Test)new TestIndex("testMinProbability"));
        ts.addTest((Test)new TestIndex("testMinJoinedProbability"));
        ts.addTest((Test)new TestIndex("testSquaredDataGraphSize"));
        ts.addTest((Test)new TestIndex("testSquaredIndexedSize"));
        ts.addTest((Test)new TestIndex("testIndexAllowsJoinedProbability"));
        ts.addTest((Test)new TestIndex("testIndexLevel"));
        ts.addTest((Test)new TestIndex("testNumOfIndexedResources"));
        ts.addTest((Test)new TestIndex("testIndexedSSSize"));
        ts.addTest((Test)new TestIndex("testIndexedSOSize"));
        ts.addTest((Test)new TestIndex("testIndexedOSSize"));
        ts.addTest((Test)new TestIndex("testIndexedOOSize"));
        ts.addTest((Test)new TestIndex("testNumOfIndexedProperties"));
        ts.addTest((Test)new TestIndex("testPropertyLookup1"));
        ts.addTest((Test)new TestIndex("testPropertyLookup2"));
        ts.addTest((Test)new TestIndex("testPropertyLookup3"));
        ts.addTest((Test)new TestIndex("testPropertyLookup4"));
        ts.addTest((Test)new TestIndex("testPropertyLookup5"));
        ts.addTest((Test)new TestIndex("testNumOfIndexedHistograms"));
        ts.addTest((Test)new TestIndex("testHistogram1"));
        ts.addTest((Test)new TestIndex("testHistogram2"));
        ts.addTest((Test)new TestIndex("testHistogram3"));
        ts.addTest((Test)new TestIndex("testHistogram4"));
        ts.addTest((Test)new TestIndex("testHistogramClass1"));
        ts.addTest((Test)new TestIndex("testHistogramClass2"));
        ts.addTest((Test)new TestIndex("testHistogramClass3"));
        ts.addTest((Test)new TestIndex("testHistogramClass4"));
        ts.addTest((Test)new TestIndex("testNumOfIndexedPatterns"));
        ts.addTest((Test)new TestIndex("testPattern1"));
        ts.addTest((Test)new TestIndex("testPattern2"));
        ts.addTest((Test)new TestIndex("testPattern3"));
        ts.addTest((Test)new TestIndex("testPattern4"));
        ts.addTest((Test)new TestIndex("testPattern5"));
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestIndex.oneTimeSetUp();
            }

            protected void tearDown() {
                TestIndex.oneTimeTearDown();
            }
        };
        return wrapper;
    }
}

