/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.OneToManyMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class TestOneToManyMap
extends TestCase {
    private String s0 = "s0";
    private String s1 = "s1";
    private String s2 = "s2";
    private String s3 = "s3";
    private String s4 = "s4";

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testConstruct0() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertNotNull((Object)map0);
        TestOneToManyMap.assertTrue((boolean)map0.isEmpty());
        OneToManyMap map1 = new OneToManyMap(map0);
        TestOneToManyMap.assertNotNull((Object)map1);
        TestOneToManyMap.assertTrue((boolean)map1.isEmpty());
    }

    public void testConstruct1() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s1));
        OneToManyMap map1 = new OneToManyMap(map0);
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s1));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s1, this.s2));
    }

    public void testClear() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse((boolean)map0.isEmpty());
        map0.clear();
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertTrue((boolean)map0.isEmpty());
    }

    public void testContainsKey() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertFalse((boolean)map0.containsKey(this.s0));
        TestOneToManyMap.assertFalse((boolean)map0.containsKey(this.s1));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue((boolean)map0.containsKey(this.s0));
        TestOneToManyMap.assertFalse((boolean)map0.containsKey(this.s1));
    }

    public void testContainsValue() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertFalse((boolean)map0.containsValue(this.s0));
        TestOneToManyMap.assertFalse((boolean)map0.containsValue(this.s1));
        TestOneToManyMap.assertFalse((boolean)map0.containsValue(this.s2));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertFalse((boolean)map0.containsValue(this.s0));
        TestOneToManyMap.assertTrue((boolean)map0.containsValue(this.s1));
        TestOneToManyMap.assertFalse((boolean)map0.containsValue(this.s2));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertFalse((boolean)map0.containsValue(this.s0));
        TestOneToManyMap.assertTrue((boolean)map0.containsValue(this.s1));
        TestOneToManyMap.assertTrue((boolean)map0.containsValue(this.s2));
    }

    public void testContains() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s1, this.s2));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s1, this.s2));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s1));
        TestOneToManyMap.assertTrue((boolean)map0.contains(this.s0, this.s2));
        TestOneToManyMap.assertFalse((boolean)map0.contains(this.s1, this.s2));
    }

    public void testEntrySet() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        boolean s0s1 = false;
        boolean s0s2 = false;
        boolean s3s4 = false;
        Iterator i = map0.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e2 = (Map.Entry)i.next();
            if (e2.getKey().equals(this.s0) && e2.getValue().equals(this.s1)) {
                s0s1 = true;
                continue;
            }
            if (e2.getKey().equals(this.s0) && e2.getValue().equals(this.s2)) {
                s0s2 = true;
                continue;
            }
            if (e2.getKey().equals(this.s3) && e2.getValue().equals(this.s4)) {
                s3s4 = true;
                continue;
            }
            throw new IllegalArgumentException("unexpected: " + e2);
        }
        TestOneToManyMap.assertTrue((boolean)s0s1);
        TestOneToManyMap.assertTrue((boolean)s0s2);
        TestOneToManyMap.assertTrue((boolean)s3s4);
    }

    public void testEquals() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        OneToManyMap map1 = new OneToManyMap();
        map1.put(this.s3, this.s4);
        map1.put(this.s0, this.s1);
        map1.put(this.s0, this.s2);
        OneToManyMap map2 = new OneToManyMap();
        map2.put(this.s0, this.s2);
        map2.put(this.s3, this.s4);
        TestOneToManyMap.assertTrue((boolean)map0.equals(map1));
        TestOneToManyMap.assertTrue((boolean)map1.equals(map0));
        TestOneToManyMap.assertTrue((map0.hashCode() == map1.hashCode() ? (byte)1 : 0) != 0);
        TestOneToManyMap.assertFalse((boolean)map0.equals(map2));
        TestOneToManyMap.assertFalse((boolean)map2.equals(map0));
    }

    public void testGet() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertNull((Object)map0.get(this.s0));
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertEquals((Object)this.s1, (Object)map0.get(this.s0));
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertTrue((map0.get(this.s0).equals(this.s1) || map0.get(this.s0).equals(this.s2) ? (byte)1 : 0) != 0);
    }

    public void testGetAll() {
        OneToManyMap map0 = new OneToManyMap();
        Iterator i = map0.getAll(this.s0);
        TestOneToManyMap.assertNotNull((Object)i);
        TestOneToManyMap.assertFalse((boolean)i.hasNext());
        map0.put(this.s0, this.s1);
        i = map0.getAll(this.s0);
        TestOneToManyMap.assertNotNull((Object)i);
        TestOneToManyMap.assertTrue((boolean)i.hasNext());
        TestOneToManyMap.assertEquals((Object)this.s1, i.next());
        TestOneToManyMap.assertFalse((boolean)i.hasNext());
        map0.put(this.s0, this.s2);
        i = map0.getAll(this.s0);
        TestOneToManyMap.assertNotNull((Object)i);
        boolean founds1 = false;
        boolean founds2 = false;
        while (i.hasNext()) {
            Object x = i.next();
            if (x.equals(this.s1)) {
                founds1 = true;
                continue;
            }
            if (x.equals(this.s2)) {
                founds2 = true;
                continue;
            }
            throw new IllegalArgumentException(x.toString());
        }
        TestOneToManyMap.assertTrue((boolean)founds1);
        TestOneToManyMap.assertTrue((boolean)founds2);
    }

    public void testKeySet() {
        OneToManyMap map0 = new OneToManyMap();
        HashSet<String> keys = new HashSet<String>();
        TestOneToManyMap.assertEquals(keys, (Object)map0.keySet());
        map0.put(this.s0, this.s1);
        keys.add(this.s0);
        TestOneToManyMap.assertEquals(keys, (Object)map0.keySet());
        map0.put(this.s2, this.s1);
        keys.add(this.s2);
        TestOneToManyMap.assertEquals(keys, (Object)map0.keySet());
    }

    public void testPutAll0() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        OneToManyMap map1 = new OneToManyMap();
        map1.put(this.s0, this.s2);
        map1.put(this.s3, this.s4);
        map1.put(this.s0, this.s1);
        OneToManyMap map2 = new OneToManyMap();
        map2.putAll((Map)map1);
        TestOneToManyMap.assertEquals((Object)map0, (Object)map2);
    }

    public void testPutAll1() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s3, this.s4);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put(this.s3, this.s4);
        map1.put(this.s0, this.s1);
        OneToManyMap map2 = new OneToManyMap();
        map2.putAll(map1);
        TestOneToManyMap.assertEquals((Object)map0, (Object)map2);
    }

    public void testRemove0() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s3, this.s4);
        map0.remove(this.s0);
        map0.remove(this.s3);
        TestOneToManyMap.assertTrue((boolean)map0.isEmpty());
    }

    public void testRemove1() {
        OneToManyMap map0 = new OneToManyMap();
        map0.put(this.s0, this.s1);
        map0.put(this.s0, this.s2);
        map0.put(this.s3, this.s4);
        map0.remove(this.s0, this.s2);
        map0.remove(this.s3, this.s4);
        TestOneToManyMap.assertFalse((boolean)map0.isEmpty());
        map0.remove(this.s0, this.s1);
        TestOneToManyMap.assertTrue((boolean)map0.isEmpty());
    }

    public void testSize() {
        OneToManyMap map0 = new OneToManyMap();
        TestOneToManyMap.assertEquals((int)0, (int)map0.size());
        map0.put(this.s0, this.s1);
        TestOneToManyMap.assertEquals((int)1, (int)map0.size());
        map0.put(this.s0, this.s2);
        TestOneToManyMap.assertEquals((int)2, (int)map0.size());
        map0.put(this.s3, this.s4);
        TestOneToManyMap.assertEquals((int)3, (int)map0.size());
        map0.remove(this.s0, this.s2);
        TestOneToManyMap.assertEquals((int)2, (int)map0.size());
        map0.remove(this.s3, this.s4);
        TestOneToManyMap.assertEquals((int)1, (int)map0.size());
        map0.remove(this.s0, this.s1);
        TestOneToManyMap.assertEquals((int)0, (int)map0.size());
    }

    public void testValues() {
        OneToManyMap map0 = new OneToManyMap();
        HashSet<String> vals = new HashSet<String>();
        TestOneToManyMap.assertEquals(vals, (Object)map0.values());
        map0.put(this.s0, this.s1);
        vals.add(this.s1);
        TestOneToManyMap.assertEquals(vals, (Object)map0.values());
        map0.put(this.s2, this.s1);
        TestOneToManyMap.assertEquals(vals, (Object)map0.values());
        map0.put(this.s2, this.s3);
        vals.add(this.s3);
        TestOneToManyMap.assertEquals(vals, (Object)map0.values());
    }
}

