/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.Bootstrapper;
import edu.uiuc.ncsa.security.servlet.ServletConfigUtil;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import java.io.File;
import javax.servlet.ServletContext;

public abstract class AbstractClientBootstrapper
extends Bootstrapper {
    protected static final String OA4MP_CONFIG_FILE_KEY = "oa4mp:client.config.file";
    protected static final String OA4MP_CONFIG_NAME_KEY = "oa4mp:client.config.name";
    public static final String DEFAULT_CONFIG_FILE_NAME = "client.xml";
    public static final String[] DEFAULT_CONFIG_LOCATIONS = new String[]{System.getProperty("user.home") + File.separator + "oa4mp" + File.separator + "client.xml", System.getProperty("user.home") + File.separator + "client.xml", System.getProperty("user.dir") + File.separator + "oa4mp" + File.separator + "client.xml", System.getProperty("user.dir") + File.separator + "client.xml", "/var/www/config/client.xml", "/var/www/config/oa4mp/client.xml"};

    public String getOa4mpConfigFileKey() {
        return OA4MP_CONFIG_FILE_KEY;
    }

    public String getOa4mpConfigNameKey() {
        return OA4MP_CONFIG_NAME_KEY;
    }

    public ConfigurationLoader loadFromDefaultLocations(MyLoggingFacade logger, String configName) throws Exception {
        logger.info("Searching for configuration name \"" + (configName == null ? "null" : configName) + "\"");
        for (String fileName : DEFAULT_CONFIG_LOCATIONS) {
            logger.info("Searching for configuration file \"" + fileName + "\"");
            File f = new File(fileName);
            if (!f.exists() || !f.isFile()) continue;
            try {
                logger.info("loading configuration \"" + (configName == null ? "(none)" : configName) + "\" from file " + fileName);
                return this.getConfigurationLoader(ConfigUtil.findConfiguration(fileName, configName, "client"));
            }
            catch (Throwable t) {
                logger.info("  ** configuration not found for \"" + fileName + "\"");
            }
        }
        return null;
    }

    @Override
    public ConfigurationLoader getConfigurationLoader(ServletContext servletContext) throws Exception {
        MyLoggingFacade logger = new MyLoggingFacade(this.getClass().getSimpleName());
        logger.info("Starting to load configuration");
        try {
            ConfigurationLoader x = this.getConfigurationLoader(ServletConfigUtil.findConfigurationNode(servletContext, this.getOa4mpConfigFileKey(), this.getOa4mpConfigNameKey(), "client"));
            logger.info("Loaded configuration named " + servletContext.getInitParameter(this.getOa4mpConfigNameKey()) + " from file " + servletContext.getInitParameter(this.getOa4mpConfigFileKey()));
            return x;
        }
        catch (MyConfigurationException ce) {
            logger.info("Did not find a configuration via the servlet context:" + ce.getMessage());
            logger.info("No configuration found in servlet context. Trying default locations");
            String configName = servletContext.getInitParameter(this.getOa4mpConfigNameKey());
            ConfigurationLoader loader = this.loadFromDefaultLocations(logger, configName);
            if (loader != null) {
                return loader;
            }
            MyConfigurationException cx = new MyConfigurationException("Error: No configuration found anyplace. OA4MP client startup aborted!");
            logger.error(cx);
            throw cx;
        }
    }
}

