/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientExceptionHandler;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.ValidTimestampPolicy;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.Initialization;
import javax.servlet.ServletException;

public class ClientServletInitializer
implements Initialization {
    protected ExceptionHandler exceptionHandler;
    protected boolean hasRun = false;
    AbstractEnvironment environment;
    AbstractServlet servlet;

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ClientExceptionHandler((ClientServlet)this.getServlet(), this.getEnvironment().getMyLogger());
        }
        return this.exceptionHandler;
    }

    @Override
    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public void init() throws ServletException {
        if (this.hasRun) {
            return;
        }
        this.hasRun = true;
        MyLoggingFacade logger = this.getEnvironment().getMyLogger();
        ClientEnvironment ce = (ClientEnvironment)this.getEnvironment();
        if (ce.hasAssetStore()) {
            Cleanup<Identifier, Asset> assetCleanup = ClientServlet.assetCleanup;
            if (ce.isEnableAssetCleanup() && assetCleanup == null) {
                assetCleanup = new Cleanup(logger);
                assetCleanup.setStopThread(false);
                assetCleanup.setMap(ce.getAssetStore());
                assetCleanup.addRetentionPolicy(new ValidTimestampPolicy(ce.getMaxAssetLifetime()));
                logger.info("Starting asset cleanup thread");
                assetCleanup.start();
                ClientServlet.assetCleanup = assetCleanup;
            }
        } else {
            logger.info("No assets store, so no cleanup possible.");
        }
    }

    @Override
    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public AbstractServlet getServlet() {
        return this.servlet;
    }

    @Override
    public void setServlet(AbstractServlet servlet) {
        this.servlet = servlet;
    }
}

