/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.cache;

import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Cleanup<K, V>
extends Thread {
    MyLoggingFacade logger;
    public long cleanupInterval = 60000L;
    Map<K, V> map;
    volatile boolean stopThread = false;
    LinkedList<RetentionPolicy> retentionPolicies;

    public Cleanup(MyLoggingFacade logger) {
        this.logger = logger;
    }

    public List<V> age() {
        LinkedList<V> linkedList = new LinkedList<V>();
        if (this.getMap().size() == 0) {
            return linkedList;
        }
        for (K key : this.getSortedKeys()) {
            V co = this.getMap().get(key);
            for (RetentionPolicy rp : this.getRetentionPolicies()) {
                if (!rp.applies() || rp.retain(key, co)) continue;
                this.getMap().remove(key);
                linkedList.add(co);
            }
        }
        return linkedList;
    }

    public Set<K> getSortedKeys() {
        TreeSet<K> sortedList = new TreeSet<K>();
        sortedList.addAll(this.getMap().keySet());
        return sortedList;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public void setMap(Map<K, V> map) {
        this.map = map;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    public void setStopThread(boolean stopThread) {
        this.stopThread = stopThread;
    }

    public void addRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.getRetentionPolicies().add(retentionPolicy);
    }

    public void removeRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.getRetentionPolicies().remove(retentionPolicy);
    }

    public List<RetentionPolicy> getRetentionPolicies() {
        if (this.retentionPolicies == null) {
            this.retentionPolicies = new LinkedList();
        }
        return this.retentionPolicies;
    }

    public void setRetentionPolicies(LinkedList<RetentionPolicy> retentionPolicies) {
        this.retentionPolicies = retentionPolicies;
    }

    protected void log(String x) {
        this.logger.info(x);
    }

    public void log(List<V> removed) {
        this.log("removed:" + removed.size() + ", remaining:" + this.getMap().size());
    }

    @Override
    public void run() {
        this.log("starting cleanup thread for " + this.getMap());
        while (!this.isStopThread()) {
            try {
                Cleanup.sleep(this.getCleanupInterval());
                if (this.getMap() == null) continue;
                try {
                    List<V> removed = this.age();
                    if (removed.isEmpty()) continue;
                    this.log(removed);
                }
                catch (Throwable throwable) {
                    int sz = -1;
                    try {
                        sz = this.getMap().size();
                        if (0 < sz) {
                            String msg = throwable.getMessage() == null ? "(no message available)" : throwable.getMessage();
                            this.logger.warn("Error in cleanup:\"" + msg + "\" Processing will continue on " + sz + " elements.");
                        }
                    }
                    catch (Throwable x) {
                        String msg = x.getMessage() == null ? "(no message available)" : x.getMessage();
                        this.logger.warn("Error in cleanup:\"" + msg + "\" Processing will continue.");
                    }
                    return;
                }
            }
            catch (InterruptedException e2) {
                this.setStopThread(true);
                this.logger.warn("Cleanup interrupted, stopping thread...");
            }
        }
    }
}

