/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.Identifiers;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.inject.Provider;

public abstract class IdentifierProvider<V extends Identifier>
implements Provider<V> {
    public static final String SCHEME = "myproxy";
    public static final String SCHEME_SPECIFIC_PART = "oa4mp,2012:";
    protected String uriScheme;
    protected String schemeSpecificPart;
    String caput;
    protected boolean useTimestamps;
    protected String component;

    protected IdentifierProvider(URI uri, String component, boolean useTimestamps) {
        this.uriScheme = uri.getScheme();
        this.schemeSpecificPart = uri.getSchemeSpecificPart();
        this.component = component;
        this.useTimestamps = useTimestamps;
    }

    protected IdentifierProvider(String component) {
        this(SCHEME, SCHEME_SPECIFIC_PART, component, true);
    }

    protected IdentifierProvider(String scheme, String schemeSpecificPart, String component, boolean useTimestamps) {
        this.useTimestamps = useTimestamps;
        this.schemeSpecificPart = schemeSpecificPart;
        this.uriScheme = scheme;
        this.component = component;
    }

    protected String getCaput() {
        if (this.caput == null) {
            URI x = null;
            try {
                x = new URI(this.uriScheme, this.schemeSpecificPart, null);
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace();
                throw new GeneralException("Error: Could not create uri for identifiers.", e2);
            }
            this.caput = x.toString();
        }
        return this.caput;
    }

    protected URI uniqueIdentifier() {
        String h = "";
        if (this.component != null) {
            h = this.component.startsWith("/") ? "" : "/" + this.component;
            h = h + (this.component.endsWith("/") ? "" : "/");
        }
        String t = "";
        if (this.useTimestamps) {
            t = "/" + Long.toString(new Date().getTime());
        }
        return Identifiers.uniqueIdentifier(this.getCaput() + h, t);
    }

    @Override
    public V get() {
        return (V)new BasicIdentifier(this.uniqueIdentifier());
    }
}

