/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Iso8601 {
    protected static String zeros = "00000";
    static int dateIndex = 0;
    static int timezoneIndex = 1;

    public static String date2String(long d) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(d);
        return Iso8601.date2String(c);
    }

    public static String date2String(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return Iso8601.date2String(c);
    }

    public static String date2String(Calendar c) {
        return Iso8601.getUTCDateFormat().format(c.getTime());
    }

    public static DateFormat getUTCDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static DateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    protected static String fixSeconds(String rawDate) throws ParseException {
        try {
            int decimalPointLocation = rawDate.lastIndexOf(".");
            if (decimalPointLocation == -1) {
                return rawDate + ".000";
            }
            int secondsLength = rawDate.length() - decimalPointLocation - 1;
            if (3 < secondsLength) {
                return rawDate.substring(0, decimalPointLocation + 4);
            }
            return rawDate + zeros.substring(0, 3 - secondsLength);
        }
        catch (Throwable t) {
            throw new ParseException("error parsing date \"" + rawDate + "\"", 0);
        }
    }

    public static synchronized String[] splitDate(String rawDate) throws ParseException {
        try {
            String[] result = new String[2];
            if (rawDate.endsWith("Z")) {
                result[Iso8601.dateIndex] = Iso8601.fixSeconds(rawDate.substring(0, rawDate.length() - 1));
                result[Iso8601.timezoneIndex] = "+0000";
            } else {
                int colonOffset = rawDate.lastIndexOf(":") == rawDate.length() - 3 ? 1 : 0;
                int plusMinusLocation = rawDate.length() - (5 + colonOffset);
                result[Iso8601.dateIndex] = Iso8601.fixSeconds(rawDate.substring(0, plusMinusLocation));
                result[Iso8601.timezoneIndex] = rawDate.substring(plusMinusLocation, plusMinusLocation + 3) + rawDate.substring(rawDate.length() - 2);
            }
            return result;
        }
        catch (Throwable t) {
            throw new ParseException("error parsing date \"" + rawDate + "'", 0);
        }
    }

    public static Calendar string2Date(String s) throws ParseException {
        String[] date2 = Iso8601.splitDate(s);
        Calendar c = Iso8601.mintCalendar();
        c.setTime(Iso8601.getDateFormat().parse(date2[dateIndex] + date2[timezoneIndex]));
        return c;
    }

    protected static Calendar mintCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        return c;
    }
}

