/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.Version;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.LoggerProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class LoggingConfigLoader<T extends AbstractEnvironment>
implements Serializable,
Version,
ConfigurationLoader<T> {
    protected ConfigurationNode cn;
    protected Provider<MyLoggingFacade> loggerProvider;
    protected MyLoggingFacade myLogger = null;

    public abstract String getVersionString();

    public LoggingConfigLoader(ConfigurationNode node, MyLoggingFacade logger) {
        this.cn = node;
        List list = node.getChildren("logging");
        ConfigurationNode currentNode = null;
        if (!list.isEmpty()) {
            currentNode = (ConfigurationNode)list.get(0);
        }
        this.loggerProvider = logger == null ? (currentNode != null ? new LoggerProvider(currentNode) : new LoggerProvider("delegation.xml", "NCSA Delegation", 1, 1000000, true, false, true)) : new MyLoggerProvider(logger);
        String startupVersion = this.getVersionString() + " startup on " + new Date();
        System.out.println(startupVersion);
        this.myLogger = this.loggerProvider.get();
        this.info(startupVersion);
    }

    public LoggingConfigLoader(ConfigurationNode node) {
        this(node, null);
    }

    protected void warn(Object infoString) {
        if (this.myLogger != null) {
            this.myLogger.warn(infoString.toString());
        }
    }

    protected void info(Object infoString) {
        if (this.myLogger != null) {
            this.myLogger.info(infoString.toString());
        }
    }

    protected void debug(Object infoString) {
        if (this.myLogger != null) {
            this.myLogger.debug(infoString.toString());
        }
    }

    protected class MyLoggerProvider
    implements Provider<MyLoggingFacade> {
        MyLoggingFacade logger;

        @Override
        public MyLoggingFacade get() {
            return this.logger;
        }

        public MyLoggerProvider(MyLoggingFacade logger) {
            this.logger = logger;
        }
    }
}

