/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.client;

import edu.uiuc.ncsa.security.delegation.client.request.AGRequest;
import edu.uiuc.ncsa.security.delegation.client.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.client.request.ATRequest;
import edu.uiuc.ncsa.security.delegation.client.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationResponse;
import edu.uiuc.ncsa.security.delegation.client.request.PARequest;
import edu.uiuc.ncsa.security.delegation.client.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.client.server.AGServer;
import edu.uiuc.ncsa.security.delegation.client.server.ATServer;
import edu.uiuc.ncsa.security.delegation.client.server.PAServer;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.services.Response;
import edu.uiuc.ncsa.security.delegation.services.Server;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import java.net.URI;
import java.util.Map;

public abstract class DelegationService
implements Server {
    ATServer atServer;
    AGServer agServer;
    PAServer paServer;

    protected DelegationService(AGServer agServer, ATServer atServer, PAServer paServer) {
        this.agServer = agServer;
        this.atServer = atServer;
        this.paServer = paServer;
    }

    public DelegationResponse processDelegationRequest(DelegationRequest delegationRequest) {
        AGRequest agReq = new AGRequest();
        agReq.setClient(delegationRequest.getClient());
        agReq.setParameters(delegationRequest.getParameters());
        AGResponse agResp = (AGResponse)this.getAgServer().process(agReq);
        DelegationResponse delResp = new DelegationResponse(agResp.getAuthorizationGrant());
        delResp.setRedirectUri(this.createRedirectURL(delegationRequest, agResp));
        return delResp;
    }

    protected ATResponse getAT(AuthorizationGrant grant, Client client, Map<String, String> parameters) {
        return this.getAT(grant, client, parameters);
    }

    protected ATResponse getAT(AuthorizationGrant grant, Verifier v, Client client, Map<String, String> parameters) {
        ATRequest atr = new ATRequest();
        atr.setAuthorizationGrant(grant);
        atr.setVerifier(v);
        atr.setClient(client);
        atr.setParameters(parameters);
        ATResponse atresp = (ATResponse)this.getAtServer().process(atr);
        return atresp;
    }

    public ATResponse getAT(DelegatedAssetRequest delegationAssetRequest) {
        return this.getAT(delegationAssetRequest.getAuthorizationGrant(), delegationAssetRequest.getVerifier(), delegationAssetRequest.getClient(), delegationAssetRequest.getParameters());
    }

    public DelegatedAssetResponse processAssetRequest(DelegatedAssetRequest delegationAssetRequest) {
        ATResponse atResp = this.getAT(delegationAssetRequest);
        return this.getCert(atResp, delegationAssetRequest.getClient(), delegationAssetRequest.getAssetParameters());
    }

    public DelegatedAssetResponse getCert(ATResponse atResponse, Client client, Map<String, String> assetParameters) {
        PARequest paReq = new PARequest();
        paReq.setClient(client);
        paReq.setAccessToken(atResponse.getAccessToken());
        paReq.setParameters(assetParameters);
        PAResponse paResp = (PAResponse)this.getPaServer().process(paReq);
        DelegatedAssetResponse dap = new DelegatedAssetResponse(paResp.getProtectedAsset());
        dap.setAdditionalInformation(paResp.getAdditionalInformation());
        return dap;
    }

    public abstract URI createRedirectURL(DelegationRequest var1, AGResponse var2);

    @Override
    public Response process(Request request) {
        return request.process(this);
    }

    public ATServer getAtServer() {
        return this.atServer;
    }

    public PAServer getPaServer() {
        return this.paServer;
    }

    public AGServer getAgServer() {
        return this.agServer;
    }
}

