/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.server.storage.support;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.storage.support.ServiceTransactionKeys;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransactionConverter;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;

public class ServiceTransactionConverter<V extends ServiceTransaction>
extends BasicTransactionConverter<V> {
    public ServiceTransactionConverter(SerializationKeys keys, IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge) {
        super(keys, identifiableProvider, tokenForge);
    }

    @Override
    public V fromMap(ConversionMap<String, Object> map, V v) {
        ServiceTransaction value = (ServiceTransaction)super.fromMap(map, v);
        value.setAuthGrantValid(map.getBoolean(this.getSTK().tempCredValid(new String[0])));
        value.setAccessTokenValid(map.getBoolean(this.getSTK().accessTokenValid(new String[0])));
        value.setCallback(map.getURI(this.getSTK().callbackUri(new String[0])));
        value.setLifetime(map.getLong(this.getSTK().lifetime(new String[0])));
        return (V)value;
    }

    protected ServiceTransactionKeys getSTK() {
        return (ServiceTransactionKeys)this.getBTKeys();
    }

    @Override
    public void toMap(V v, ConversionMap<String, Object> map) {
        super.toMap(v, map);
        map.put(this.getSTK().tempCredValid(new String[0]), ((ServiceTransaction)v).isAuthGrantValid());
        map.put(this.getSTK().accessTokenValid(new String[0]), ((ServiceTransaction)v).isAccessTokenValid());
        if (((ServiceTransaction)v).getCallback() != null) {
            map.put(this.getSTK().callbackUri(new String[0]), ((ServiceTransaction)v).getCallback().toString());
        }
        map.put(this.getSTK().lifetime(new String[0]), ((ServiceTransaction)v).getLifetime());
    }
}

