/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.delegation.storage.BaseClient;

public class Client
extends BaseClient {
    boolean proxyLimited = false;
    String homeUri;
    String errorUri;

    @Override
    public Client clone() {
        Client c = new Client(this.getIdentifier());
        c.setCreationTS(this.getCreationTS());
        c.setEmail(this.getEmail());
        c.setErrorUri(this.getErrorUri());
        c.setHomeUri(this.getHomeUri());
        c.setName(this.getName());
        c.setProxyLimited(this.isProxyLimited());
        c.setSecret(this.getSecret());
        return c;
    }

    public boolean isProxyLimited() {
        return this.proxyLimited;
    }

    public void setProxyLimited(boolean proxyLimited) {
        this.proxyLimited = proxyLimited;
    }

    public Client(Identifier identifier) {
        super(identifier);
    }

    public String getHomeUri() {
        return this.homeUri;
    }

    public void setHomeUri(String homeUri) {
        this.homeUri = homeUri;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Client c = (Client)obj;
        if (!BeanUtils.checkEquals(this.getHomeUri(), c.getHomeUri())) {
            return false;
        }
        if (!BeanUtils.checkEquals(this.getErrorUri(), c.getErrorUri())) {
            return false;
        }
        return this.isProxyLimited() == c.isProxyLimited();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[name=\"" + this.getName() + "\", id=\"" + this.getIdentifierString() + "\", homeUri=\"" + this.getHomeUri() + "\", errorUri=\"" + this.getErrorUri() + "\", email=\"" + this.getEmail() + "\", secret=" + (this.getSecret() == null ? "(none)" : this.getSecret().substring(0, 25)) + "\", proxy limited=" + this.isProxyLimited() + "]";
    }
}

