/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.storage.BaseClient;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.ClientKeys;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;

public class ClientConverter<V extends Client>
extends MapConverter<V> {
    public ClientConverter(IdentifiableProvider<V> identifiableProvider) {
        this(new ClientKeys(), identifiableProvider);
    }

    public ClientConverter(SerializationKeys keys, IdentifiableProvider<V> identifiableProvider) {
        super(keys, identifiableProvider);
    }

    protected ClientKeys getCK() {
        return (ClientKeys)this.keys;
    }

    @Override
    public V fromMap(ConversionMap<String, Object> map, V v) {
        Client value = (Client)super.fromMap(map, v);
        value.setName(map.getString(this.getCK().name(new String[0])));
        value.setHomeUri(map.getString(this.getCK().homeURL(new String[0])));
        value.setCreationTS(map.getDate(this.getCK().creationTS(new String[0])));
        value.setErrorUri(map.getString(this.getCK().errorURL(new String[0])));
        value.setSecret(map.getString(this.getCK().secret(new String[0])));
        value.setEmail(map.getString(this.getCK().email(new String[0])));
        value.setProxyLimited(map.getBoolean(this.getCK().proxyLimited(new String[0])));
        return (V)value;
    }

    @Override
    public void toMap(V client, ConversionMap<String, Object> map) {
        super.toMap(client, map);
        map.put(this.getCK().secret(new String[0]), ((BaseClient)client).getSecret());
        map.put(this.getCK().name(new String[0]), ((BaseClient)client).getName());
        map.put(this.getCK().homeURL(new String[0]), ((Client)client).getHomeUri());
        map.put(this.getCK().creationTS(new String[0]), ((BaseClient)client).getCreationTS());
        map.put(this.getCK().errorURL(new String[0]), ((Client)client).getErrorUri());
        map.put(this.getCK().email(new String[0]), ((BaseClient)client).getEmail());
        map.put(this.getCK().proxyLimited(new String[0]), ((Client)client).isProxyLimited());
    }
}

