/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.token.impl;

import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.delegation.token.Token;
import java.net.URI;

public class TokenImpl
implements Token {
    URI token;
    URI sharedSecret;

    public TokenImpl(URI token, URI sharedSecret) {
        this.sharedSecret = sharedSecret;
        this.token = token;
    }

    public URI getURISharedSecret() {
        return this.sharedSecret;
    }

    public String getSharedSecret() {
        if (this.sharedSecret == null) {
            return null;
        }
        return this.getURISharedSecret().toString();
    }

    public void setSharedSecret(String sharedSecret) {
        if (sharedSecret == null) {
            this.sharedSecret = null;
        } else {
            this.setSharedSecret(URI.create(sharedSecret));
        }
    }

    public void setSharedSecret(URI sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @Override
    public String getToken() {
        if (this.token == null) {
            return null;
        }
        return this.getURIToken().toString();
    }

    public URI getURIToken() {
        return this.token;
    }

    public void setToken(URI token) {
        this.token = token;
    }

    public boolean equals(Object obj) {
        if (obj == null && this.getURIToken() == null && this.getSharedSecret() == null) {
            return true;
        }
        if (!(obj instanceof TokenImpl)) {
            return false;
        }
        TokenImpl at = (TokenImpl)obj;
        if (!BeanUtils.checkNoNulls(this.getURIToken(), at.getURIToken())) {
            return false;
        }
        return BeanUtils.checkNoNulls(this.getSharedSecret(), at.getSharedSecret());
    }

    public String toString() {
        String out = this.getClass().getSimpleName() + "[";
        out = this.getToken() == null ? out + "token=(null)" : out + "token=" + this.getToken();
        out = this.getSharedSecret() == null ? out + "]" : out + ", secret=" + this.getSharedSecret() + "]";
        return out;
    }
}

