/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthConstants;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthHTTPSClientPool;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.util.ssl.VerifyingHTTPClientFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.SimpleOAuthValidator;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.server.OAuthServlet;

public class OAuthUtilities
implements OAuthConstants {
    static VerifyingHTTPClientFactory clientFactory;

    public static OAuthAccessor createOAuthAccessor(AddressableServer authorizationServer, OAClient client) {
        String resourceUri = authorizationServer.getAddress().toString();
        OAuthServiceProvider provider = new OAuthServiceProvider(resourceUri, resourceUri, resourceUri);
        OAuthConsumer consumer = new OAuthConsumer(client.getHomeUri(), client.getIdentifierString(), client.getSecret(), provider);
        consumer.setProperty("oauth_signature_method", client.getSignatureMethod());
        consumer.setProperty("oauth_callback", client.getHomeUri());
        return new OAuthAccessor(consumer);
    }

    public static VerifyingHTTPClientFactory getClientFactory() {
        return clientFactory;
    }

    public static void setClientFactory(VerifyingHTTPClientFactory clientFactory) {
        OAuthUtilities.clientFactory = clientFactory;
    }

    public static OAuthHTTPSClientPool newClientPool(URI address) throws IOException {
        return new OAuthHTTPSClientPool(OAuthUtilities.getClientFactory().getClient(address.getHost()));
    }

    public static OAuthClient newOAuthClient(URI address) throws IOException {
        return new OAuthClient(new HttpClient4(OAuthUtilities.newClientPool(address)));
    }

    public static void validate(OAuthMessage message, OAuthAccessor accessor) {
        try {
            SimpleOAuthValidator validator = new SimpleOAuthValidator();
            validator.validateMessage(message, accessor);
        }
        catch (Exception e2) {
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new GeneralException("Error validating message", e2);
        }
    }

    public static OAuthMessage getMessage(HttpServletRequest request) throws ServletException, IOException {
        return OAuthServlet.getMessage(request, null);
    }

    public static Map<String, String> getParameters(HttpServletRequest request) throws IOException, ServletException {
        return OAuthUtilities.getParameters(OAuthUtilities.getMessage(request));
    }

    public static Map<String, String> getParameters(OAuthMessage message) throws IOException {
        HashMap<String, String> x = new HashMap<String, String>();
        for (Map.Entry<String, String> p : message.getParameters()) {
            x.put(p.getKey().toString(), p.getValue().toString());
        }
        return x;
    }

    public static HashMap whittleParameters(OAuthMessage message) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Map.Entry<String, String> ee : message.getParameters()) {
            if (ee.getKey().startsWith("oauth_")) continue;
            m.put(ee.getKey(), ee.getValue());
        }
        return m;
    }

    public static HashMap<String, String> whittleMap(Map<String, String> map) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String k : map.keySet()) {
            if (k.startsWith("oauth_")) continue;
            m.put(k, map.get(k));
        }
        return m;
    }
}

