/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.servlet;

import edu.uiuc.ncsa.security.core.Logable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.BasicExceptionHandler;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.Initialization;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractServlet
extends HttpServlet
implements Logable {
    public static final String PING_PARAMETER = "ping";
    static ConfigurationLoader<? extends AbstractEnvironment> configurationLoader;
    protected static Initialization initialization;
    protected static AbstractEnvironment environment;
    MyLoggingFacade myLogger;
    ExceptionHandler exceptionHandler;

    public static Initialization getInitialization() {
        return initialization;
    }

    public static void setInitialization(Initialization initialization) {
        AbstractServlet.initialization = initialization;
    }

    public static ConfigurationLoader<? extends AbstractEnvironment> getConfigurationLoader() {
        return configurationLoader;
    }

    public static void setConfigurationLoader(ConfigurationLoader<? extends AbstractEnvironment> b) {
        configurationLoader = b;
    }

    public static AbstractEnvironment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(AbstractEnvironment env) {
        environment = env;
    }

    public abstract void loadEnvironment() throws IOException;

    @Override
    public boolean isDebugOn() {
        return this.getMyLogger().isDebugOn();
    }

    @Override
    public void setDebugOn(boolean setOn) {
        this.getMyLogger().setDebugOn(setOn);
    }

    protected MyLoggingFacade getMyLogger() {
        if (environment != null) {
            return environment.getMyLogger();
        }
        return new MyLoggingFacade("oa4mp");
    }

    @Override
    public void debug(String x) {
        this.getMyLogger().debug(x);
    }

    @Override
    public void error(String x) {
        this.getMyLogger().error(x);
    }

    @Override
    public void info(String x) {
        this.getMyLogger().info(x);
    }

    @Override
    public void warn(String x) {
        this.getMyLogger().warn(x);
    }

    protected void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.error("INTERNAL ERROR: " + (t.getMessage() == null ? "(no message)" : t.getMessage()));
        if (this.isDebugOn()) {
            t.printStackTrace();
        }
        t.printStackTrace();
        this.getExceptionHandler().handleException(t, request, response);
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.warn("Warning: no Exception Handler set, using basic exception handling only!");
            this.exceptionHandler = new BasicExceptionHandler(this.getMyLogger());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (this.doPing(httpServletRequest, httpServletResponse)) {
                return;
            }
            this.doIt(httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            this.handleException(t, httpServletRequest, httpServletResponse);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (this.doPing(httpServletRequest, httpServletResponse)) {
                return;
            }
            this.doIt(httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.handleException(t, httpServletRequest, httpServletResponse);
        }
    }

    protected boolean doPing(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (req.getParameterMap().containsKey(PING_PARAMETER)) {
            if (!AbstractServlet.getEnvironment().isPingable()) {
                this.warn("Ping attempted on server. Ping not enabled.");
                throw new ServletException("Internal error");
            }
            this.info("ping ok");
            resp.setStatus(204);
            return true;
        }
        return false;
    }

    protected abstract void doIt(HttpServletRequest var1, HttpServletResponse var2) throws Throwable;

    public void init() throws ServletException {
        super.init();
        if (environment == null) {
            this.info("loading environment...");
            try {
                this.loadEnvironment();
            }
            catch (IOException e2) {
                this.warn("failed to load environment.");
                throw new GeneralException("Error loading environment", e2);
            }
            this.info("done loading environment.");
        }
        if (AbstractServlet.getInitialization() == null) {
            this.info("Caution: no initializer set for " + this.getClass().getSimpleName() + ". Skipping...");
        } else {
            AbstractServlet.getInitialization().setEnvironment(AbstractServlet.getEnvironment());
            AbstractServlet.getInitialization().setServlet(this);
            AbstractServlet.getInitialization().init();
            this.setExceptionHandler(AbstractServlet.getInitialization().getExceptionHandler());
        }
    }

    public void resetState() {
        environment = null;
    }

    protected static String CONST(String key) {
        return AbstractServlet.getEnvironment().getConstants().get(key);
    }

    protected String getFirstParameterValue(HttpServletRequest request, String key) {
        String obj = request.getParameter(key);
        if (obj == null) {
            return null;
        }
        if (!obj.getClass().isArray()) {
            return obj.toString();
        }
        String[] values = (String[])obj;
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    protected void printAllParameters(HttpServletRequest request) {
        String reqUrl = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (queryString != null) {
            reqUrl = reqUrl + "?" + queryString;
        }
        System.err.println("\n" + this.getClass().getSimpleName() + " at " + new Date());
        System.err.println("Request parameters for " + reqUrl + "");
        if (request.getParameterMap() == null || request.getParameterMap().isEmpty()) {
            System.err.println("  (none)");
        } else {
            for (Object key : request.getParameterMap().keySet()) {
                String[] values = request.getParameterValues(key.toString());
                System.err.println(" " + key + ":");
                if (values == null || values.length == 0) {
                    System.err.println("   (no values)");
                    continue;
                }
                for (String x : values) {
                    System.err.println("   " + x);
                }
            }
        }
        System.err.println("Cookies:");
        if (request.getCookies() == null) {
            System.err.println(" (none)");
        } else {
            for (Cookie c : request.getCookies()) {
                System.err.println(" " + c.getName() + "=" + c.getValue());
            }
        }
        System.err.println("Headers:");
        Enumeration e2 = request.getHeaderNames();
        if (!e2.hasMoreElements()) {
            System.err.println(" (none)");
        } else {
            while (e2.hasMoreElements()) {
                String name = e2.nextElement().toString();
                System.err.println(" " + name);
                System.err.println("   " + request.getHeader(name));
            }
        }
    }
}

