/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.servlet;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ServletConfigUtil
extends ConfigUtil {
    public static ConfigurationNode findConfigurationNode(ServletContext servletContext, String configFileKey, String configName, String topNodeTag) {
        String fileName = servletContext.getInitParameter(configFileKey);
        if (fileName == null || fileName.length() == 0) {
            throw new MyConfigurationException("Error: No configuration file was specified in the servlet configuration.");
        }
        try {
            return ServletConfigUtil.findConfiguration(fileName, servletContext.getInitParameter(configName), topNodeTag);
        }
        catch (MyConfigurationException cx) {
            cx.printStackTrace();
            URL url = null;
            try {
                url = servletContext.getResource(fileName);
            }
            catch (MalformedURLException e2) {
                throw new MyConfigurationException("Error: Could not parse URL \"" + fileName + "\". Has a valid configuration been specified?", e2);
            }
            if (url == null) {
                throw cx;
            }
            XMLConfiguration cfg = Configurations.getConfiguration(url);
            return ServletConfigUtil.findNamedConfig(cfg, servletContext.getInitParameter(configName), topNodeTag);
        }
    }
}

