/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.sql.AdminConnectionParameters;
import edu.uiuc.ncsa.security.storage.sql.SQLDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DBInitializer
extends SQLDatabase
implements Initializable {
    public String getDatabaseName() {
        return this.getAdminConnectionParameters().getDatabaseName();
    }

    protected AdminConnectionParameters getAdminConnectionParameters() {
        return (AdminConnectionParameters)this.getConnectionPool().getConnectionParameters();
    }

    public String getSchema() {
        return this.getAdminConnectionParameters().getSchema();
    }

    public String getUser() {
        return this.getAdminConnectionParameters().getClientUsername();
    }

    public abstract void setPermissions(Statement var1) throws SQLException;

    public abstract void createSchema(Statement var1) throws SQLException;

    public abstract void dropSchema(Statement var1) throws SQLException;

    public abstract void createTables(Statement var1) throws SQLException;

    public abstract void recreateTransactionTables(Statement var1) throws SQLException;

    public abstract void dropTables(Statement var1) throws SQLException;

    protected void init2() throws SQLException {
        Connection c = this.getConnection();
        Statement s = c.createStatement();
        try {
            this.createSchema(s);
            this.createTables(s);
            this.setPermissions(s);
        }
        finally {
            s.close();
            c.close();
        }
    }

    @Override
    public boolean init() {
        try {
            this.init2();
            return true;
        }
        catch (SQLException x) {
            throw new GeneralException(x);
        }
    }

    protected void destroy2() throws SQLException {
        Connection c = this.getConnection();
        Statement s = c.createStatement();
        try {
            this.dropTables(s);
            this.dropSchema(s);
        }
        finally {
            s.close();
            c.close();
        }
    }

    @Override
    public boolean destroy() {
        try {
            this.destroy2();
            return false;
        }
        catch (SQLException x) {
            return true;
        }
    }

    @Override
    public boolean createNew() {
        this.destroy();
        this.init();
        return false;
    }

    @Override
    public boolean isCreated() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }
}

