/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.storage.sql.ConnectionParameters;

public abstract class SQLConnectionImpl
implements ConnectionParameters {
    protected boolean useSSL = false;
    protected String host;
    protected String username;
    protected String password;
    protected int port;
    protected String jdbcDriver;
    protected String databaseName;
    protected String schema;

    protected SQLConnectionImpl(String username, String password, String databaseName, String schema, String host, int port, String jdbcDriver, boolean useSSL) {
        this.databaseName = databaseName;
        this.host = host;
        this.jdbcDriver = jdbcDriver;
        this.password = password;
        this.port = port;
        this.schema = schema;
        this.username = username;
        this.useSSL = useSSL;
        this.init();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    protected void init() {
        if (this.jdbcDriver == null) {
            throw new MyConfigurationException("Missing JDBC driver");
        }
        try {
            Class.forName(this.jdbcDriver);
        }
        catch (ClassNotFoundException e2) {
            throw new MyConfigurationException("Class not found. Could not load JDBC driver \"" + this.jdbcDriver + "\"");
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String toString() {
        String x = this.getClass().getSimpleName() + "[";
        x = x + "username=" + this.username;
        x = x + ", password=" + this.password;
        x = x + ", database=" + this.databaseName;
        x = x + ", schema=" + this.schema;
        x = x + ", host=" + this.host;
        x = x + ", port=" + this.port;
        x = x + ", jdbcDriver=" + this.jdbcDriver;
        x = x + ", useSSL? " + this.useSSL;
        x = x + ", jdbcURL=" + this.getJdbcUrl();
        x = x + "]";
        return x;
    }

    boolean compareString(String x, String y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        return x.equals(y);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLConnectionImpl)) {
            return false;
        }
        SQLConnectionImpl z = (SQLConnectionImpl)obj;
        if (!this.compareString(this.username, z.username)) {
            return false;
        }
        if (!this.compareString(this.password, z.password)) {
            return false;
        }
        if (!this.compareString(this.schema, z.schema)) {
            return false;
        }
        if (!this.compareString(this.databaseName, z.databaseName)) {
            return false;
        }
        if (!this.compareString(this.host, z.host)) {
            return false;
        }
        if (!this.compareString(this.jdbcDriver, z.jdbcDriver)) {
            return false;
        }
        if (this.port != z.port) {
            return false;
        }
        return this.useSSL == z.useSSL;
    }
}

