/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.SimpleEntryImpl;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.exceptions.UnregisteredObjectException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLDatabase;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptorEntry;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptors;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

public abstract class SQLStore<V extends Identifiable>
extends SQLDatabase
implements Store<V> {
    protected Provider<V> identifiableProvider;
    protected MapConverter<V> converter;
    Table table;

    protected SQLStore(ConnectionPool connectionPool, Table table, Provider<V> identifiableProvider, MapConverter<V> converter) {
        super(connectionPool);
        this.table = table;
        this.identifiableProvider = identifiableProvider;
        this.converter = converter;
    }

    public SQLStore() {
    }

    @Override
    public V create() {
        return (V)((Identifiable)this.identifiableProvider.get());
    }

    @Override
    public void update(V value) {
        if (!this.containsValue(value)) {
            throw new UnregisteredObjectException("Error: cannot update non-existent entry for\"" + value.getIdentifierString() + "\". Register it first or call save.");
        }
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTable().createUpdateStatement());
            ColumnMap map = this.depopulate(value);
            int i = 1;
            for (ColumnDescriptorEntry cde : this.getTable().getColumnDescriptor()) {
                if (cde.isPrimaryKey()) continue;
                Object obj = map.get(cde.getName());
                if (obj instanceof Date) {
                    obj = new Timestamp(((Date)obj).getTime());
                }
                if (obj instanceof BasicIdentifier) {
                    stmt.setString(i++, obj.toString());
                    continue;
                }
                stmt.setObject(i++, obj);
            }
            stmt.setString(i++, value.getIdentifierString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error updating approval with identifier = \"" + value.getIdentifierString(), e2);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public void populate(ColumnMap map, V t) {
        this.converter.fromMap(map, t);
    }

    public ColumnMap depopulate(V t) throws SQLException {
        ColumnMap map = new ColumnMap();
        this.converter.toMap(t, map);
        return map;
    }

    @Override
    public void save(V value) {
        if (this.containsKey(value.getIdentifier())) {
            this.update(value);
        } else {
            this.register(value);
        }
    }

    @Override
    public void register(V value) {
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTable().createInsertStatement());
            ColumnMap map = this.depopulate(value);
            int i = 1;
            for (ColumnDescriptorEntry cde : this.getTable().getColumnDescriptor()) {
                if (cde.getType() == -1) {
                    Object obj = map.get(cde.getName());
                    stmt.setString(i++, obj == null ? null : obj.toString());
                    continue;
                }
                stmt.setObject(i++, map.get(cde.getName()), cde.getType());
            }
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error: could not register object with id \"" + value.getIdentifierString() + "\"", e2);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public V get(Object o) {
        if (o == null) {
            throw new IllegalStateException("Error: a null identifier was supplied");
        }
        Identifier key = null;
        try {
            key = (Identifier)o;
        }
        catch (ClassCastException c) {
            throw new NFWException("Error casting object of type \"" + o.getClass().getName() + "\" to an Identifier.\nThis is an implementation error", c);
        }
        Connection c = this.getConnection();
        V t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTable().createSelectStatement());
            stmt.setString(1, key.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                V v = null;
                return v;
            }
            ColumnMap map = this.rsToMap(rs);
            rs.close();
            stmt.close();
            t = this.create();
            this.populate(map, t);
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting object with identifier \"" + key + "\"", e2);
        }
        finally {
            this.releaseConnection(c);
        }
        return t;
    }

    protected ColumnMap rsToMap(ResultSet rs) throws SQLException {
        ColumnMap map = new ColumnMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        for (int i = 1; i <= numberOfColumns; ++i) {
            String colName = rsmd.getColumnName(i);
            Object obj = null;
            obj = rs.getObject(colName);
            map.put(colName, obj);
        }
        return map;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public int size() {
        return this.size(this.getTable().getFQTablename());
    }

    protected int size(String tablename) {
        String query2 = "SELECT COUNT(*)  from " + tablename;
        Connection c = this.getConnection();
        int rowCount = 0;
        try {
            PreparedStatement stmt = c.prepareStatement(query2);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting the size.", e2);
        }
        finally {
            this.releaseConnection(c);
        }
        return rowCount;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Connection c = this.getConnection();
        boolean rc = false;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getTable().createSelectStatement());
            stmt.setString(1, key.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            rc = rs.next();
            rs.close();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            e2.printStackTrace();
        }
        finally {
            this.releaseConnection(c);
        }
        return rc;
    }

    @Override
    public boolean containsValue(Object o) {
        Identifiable foo;
        try {
            foo = (Identifiable)o;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.containsKey(foo.getIdentifier());
    }

    @Override
    public V put(Identifier k, V v) {
        if (v.getIdentifier().equals(k)) {
            this.save(v);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Object oldObject = null;
        try {
            oldObject = this.get(key);
        }
        catch (GeneralException x) {
            // empty catch block
        }
        String query2 = "DELETE FROM " + this.getTable().getFQTablename() + " WHERE " + this.getTable().getPrimaryKeyColumnName() + "=?";
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(query2);
            stmt.setString(1, key.toString());
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting identity providers", e2);
        }
        finally {
            this.releaseConnection(c);
        }
        return (V)oldObject;
    }

    @Override
    public void putAll(Map<? extends Identifier, ? extends V> m) {
        for (Map.Entry<Identifier, V> e2 : m.entrySet()) {
            this.register((Identifiable)e2.getValue());
        }
    }

    @Override
    public void clear() {
        String query2 = "DELETE FROM " + this.getTable().getFQTablename();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(query2);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting identity providers", e2);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public Set<Identifier> keySet() {
        HashSet<Identifier> keys = new HashSet<Identifier>();
        String query2 = "Select " + this.getTable().getPrimaryKeyColumnName() + " from " + this.getTable().getFQTablename();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement(query2);
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                keys.add(new BasicIdentifier(rs.getString(1)));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting the user ids", e2);
        }
        finally {
            this.releaseConnection(c);
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> allOfThem = new ArrayList<V>();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                V newOne = this.create();
                ColumnMap map = this.rsToMap(rs);
                this.populate(map, newOne);
                allOfThem.add(newOne);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error: could not get database object", e2);
        }
        finally {
            this.releaseConnection(c);
        }
        return allOfThem;
    }

    @Override
    public Set<Map.Entry<Identifier, V>> entrySet() {
        HashSet<Map.Entry<Identifier, V>> entries = new HashSet<Map.Entry<Identifier, V>>();
        Connection c = this.getConnection();
        try {
            PreparedStatement stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                V newOne = this.create();
                ColumnMap map = this.rsToMap(rs);
                this.populate(map, newOne);
                entries.add(new SimpleEntryImpl<Identifier, V>(newOne.getIdentifier(), newOne));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e2) {
            this.destroyConnection(c);
            throw new GeneralException("Error: could not get database object", e2);
        }
        finally {
            this.releaseConnection(c);
        }
        return entries;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[table=" + this.getTable() + "]";
    }

    public void checkColumns() throws SQLException {
        ColumnDescriptors cds = this.getTable().getColumnDescriptor();
        Connection connection = this.getConnection();
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * from " + this.getTable().getFQTablename());
        ResultSetMetaData metaData = rs.getMetaData();
        Hashtable<String, Integer> foundCols = new Hashtable<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            foundCols.put(metaData.getColumnName(i).toLowerCase(), metaData.getColumnType(i));
        }
        HashMap<Integer, String> jdbcMappings = new HashMap<Integer, String>();
        for (Field field : Types.class.getFields()) {
            try {
                jdbcMappings.put((Integer)field.get(null), field.getName());
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
        }
        jdbcMappings.put(-16, "TEXT");
        jdbcMappings.put(-1, "TEXT");
        for (ColumnDescriptorEntry cde : cds) {
            if (foundCols.containsKey(cde.getName().toLowerCase())) continue;
            System.err.println("Adding column " + cde.getName() + " of type " + cde.getType());
            String rawStmt = "Alter Table " + this.getTable().getFQTablename() + " add Column " + cde.getName() + " " + (String)jdbcMappings.get(cde.getType());
            stmt.executeUpdate(rawStmt);
        }
        rs.close();
        stmt.close();
        this.releaseConnection(connection);
    }
}

