/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signature;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.signature.Base64;
import net.oauth.signature.HMAC_SHA1;
import net.oauth.signature.PLAINTEXT;
import net.oauth.signature.RSA_SHA1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAuthSignatureMethod {
    public static final String _ACCESSOR = "-Accessor";
    private String consumerSecret;
    private String tokenSecret;
    private static final String BASE64_ENCODING = "ISO-8859-1";
    private static final Base64 BASE64 = new Base64();
    private static final Map<String, Class> NAME_TO_CLASS = new ConcurrentHashMap<String, Class>();

    public void sign(OAuthMessage message) throws OAuthException, IOException, URISyntaxException {
        message.addParameter(new OAuth.Parameter("oauth_signature", this.getSignature(message)));
    }

    public void validate(OAuthMessage message) throws IOException, OAuthException, URISyntaxException {
        message.requireParameters("oauth_signature");
        String signature = message.getSignature();
        String baseString = OAuthSignatureMethod.getBaseString(message);
        if (!this.isValid(signature, baseString)) {
            OAuthProblemException problem = new OAuthProblemException("signature_invalid");
            problem.setParameter("oauth_signature", signature);
            problem.setParameter("oauth_signature_base_string", baseString);
            problem.setParameter("oauth_signature_method", message.getSignatureMethod());
            throw problem;
        }
    }

    protected String getSignature(OAuthMessage message) throws OAuthException, IOException, URISyntaxException {
        String baseString = OAuthSignatureMethod.getBaseString(message);
        String signature = this.getSignature(baseString);
        return signature;
    }

    protected void initialize(String name, OAuthAccessor accessor) throws OAuthException {
        String secret = accessor.consumer.consumerSecret;
        if (name.endsWith(_ACCESSOR)) {
            String key = "oauth_accessor_secret";
            Object accessorSecret = accessor.getProperty("oauth_accessor_secret");
            if (accessorSecret == null) {
                accessorSecret = accessor.consumer.getProperty("oauth_accessor_secret");
            }
            if (accessorSecret != null) {
                secret = accessorSecret.toString();
            }
        }
        if (secret == null) {
            secret = "";
        }
        this.setConsumerSecret(secret);
    }

    protected abstract String getSignature(String var1) throws OAuthException;

    protected abstract boolean isValid(String var1, String var2) throws OAuthException;

    protected String getConsumerSecret() {
        return this.consumerSecret;
    }

    protected void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public static String getBaseString(OAuthMessage message) throws IOException, URISyntaxException {
        List<Map.Entry<String, String>> parameters;
        String url = message.URL;
        int q = url.indexOf(63);
        if (q < 0) {
            parameters = message.getParameters();
        } else {
            parameters = new ArrayList<Map.Entry<String, String>>();
            parameters.addAll(OAuth.decodeForm(message.URL.substring(q + 1)));
            parameters.addAll(message.getParameters());
            url = url.substring(0, q);
        }
        return OAuth.percentEncode(message.method.toUpperCase()) + '&' + OAuth.percentEncode(OAuthSignatureMethod.normalizeUrl(url)) + '&' + OAuth.percentEncode(OAuthSignatureMethod.normalizeParameters(parameters));
    }

    protected static String normalizeUrl(String url) throws URISyntaxException {
        String path;
        int index;
        boolean dropPort;
        URI uri = new URI(url);
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    protected static String normalizeParameters(Collection<? extends Map.Entry> parameters) throws IOException {
        if (parameters == null) {
            return "";
        }
        ArrayList<ComparableParameter> p = new ArrayList<ComparableParameter>(parameters.size());
        for (Map.Entry entry : parameters) {
            if ("oauth_signature".equals(entry.getKey())) continue;
            p.add(new ComparableParameter(entry));
        }
        Collections.sort(p);
        return OAuth.formEncode(OAuthSignatureMethod.getParameters(p));
    }

    public static boolean equals(String x, String y) {
        char[] b;
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        if (y.length() <= 0) {
            return x.length() <= 0;
        }
        char[] a = x.toCharArray();
        char diff = (char)(a.length != (b = y.toCharArray()).length ? (byte)1 : 0);
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            diff = (char)(diff | a[i] ^ b[j]);
            j = (j + 1) % b.length;
        }
        return diff == '\u0000';
    }

    public static boolean equals(byte[] a, byte[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (b.length <= 0) {
            return a.length <= 0;
        }
        byte diff = a.length != b.length ? (byte)1 : 0;
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            diff = (byte)(diff | a[i] ^ b[j]);
            j = (j + 1) % b.length;
        }
        return diff == 0;
    }

    public static byte[] decodeBase64(String s) {
        byte[] b;
        try {
            b = s.getBytes(BASE64_ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            System.err.println(e2 + "");
            b = s.getBytes();
        }
        return BASE64.decode(b);
    }

    public static String base64Encode(byte[] b) {
        byte[] b2 = BASE64.encode(b);
        try {
            return new String(b2, BASE64_ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            System.err.println(e2 + "");
            return new String(b2);
        }
    }

    public static OAuthSignatureMethod newSigner(OAuthMessage message, OAuthAccessor accessor) throws IOException, OAuthException {
        message.requireParameters("oauth_signature_method");
        OAuthSignatureMethod signer = OAuthSignatureMethod.newMethod(message.getSignatureMethod(), accessor);
        signer.setTokenSecret(accessor.tokenSecret);
        return signer;
    }

    public static OAuthSignatureMethod newMethod(String name, OAuthAccessor accessor) throws OAuthException {
        try {
            Class methodClass = NAME_TO_CLASS.get(name);
            if (methodClass != null) {
                OAuthSignatureMethod method = (OAuthSignatureMethod)methodClass.newInstance();
                method.initialize(name, accessor);
                return method;
            }
            OAuthProblemException problem = new OAuthProblemException("signature_method_rejected");
            String acceptable = OAuth.percentEncode(NAME_TO_CLASS.keySet());
            if (acceptable.length() > 0) {
                problem.setParameter("oauth_acceptable_signature_methods", acceptable.toString());
            }
            throw problem;
        }
        catch (InstantiationException e2) {
            throw new OAuthException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new OAuthException(e3);
        }
    }

    public static void registerMethodClass(String name, Class clazz) {
        if (clazz == null) {
            OAuthSignatureMethod.unregisterMethod(name);
        } else {
            NAME_TO_CLASS.put(name, clazz);
        }
    }

    public static void unregisterMethod(String name) {
        NAME_TO_CLASS.remove(name);
    }

    private static List<Map.Entry> getParameters(Collection<ComparableParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Map.Entry> list = new ArrayList<Map.Entry>(parameters.size());
        for (ComparableParameter parameter : parameters) {
            list.add(parameter.value);
        }
        return list;
    }

    static {
        OAuthSignatureMethod.registerMethodClass("HMAC-SHA1", HMAC_SHA1.class);
        OAuthSignatureMethod.registerMethodClass("PLAINTEXT", PLAINTEXT.class);
        OAuthSignatureMethod.registerMethodClass("RSA-SHA1", RSA_SHA1.class);
        OAuthSignatureMethod.registerMethodClass("HMAC-SHA1-Accessor", HMAC_SHA1.class);
        OAuthSignatureMethod.registerMethodClass("PLAINTEXT-Accessor", PLAINTEXT.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Map.Entry value;
        private final String key;

        ComparableParameter(Map.Entry value) {
            this.value = value;
            String n = ComparableParameter.toString(value.getKey());
            String v = ComparableParameter.toString(value.getValue());
            this.key = OAuth.percentEncode(n) + ' ' + OAuth.percentEncode(v);
        }

        private static String toString(Object from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.key.compareTo(that.key);
        }

        public String toString() {
            return this.key;
        }
    }
}

