/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final long serialVersionUID = -3162063751042475985L;
    private static final int INDENT_SIZE = 4;

    public XMLPropertyListConfiguration() {
        this.initRoot();
    }

    public XMLPropertyListConfiguration(HierarchicalConfiguration configuration) {
        super(configuration);
    }

    public XMLPropertyListConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public XMLPropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public XMLPropertyListConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        if (value instanceof byte[]) {
            this.fireEvent(3, key, value, true);
            this.setDetailEvents(false);
            try {
                this.clearProperty(key);
                this.addPropertyDirect(key, value);
            }
            finally {
                this.setDetailEvents(true);
            }
            this.fireEvent(3, key, value, false);
        } else {
            super.setProperty(key, value);
        }
    }

    public void addProperty(String key, Object value) {
        if (value instanceof byte[]) {
            this.fireEvent(1, key, value, true);
            this.addPropertyDirect(key, value);
            this.fireEvent(1, key, value, false);
        } else {
            super.addProperty(key, value);
        }
    }

    public void load(Reader in) throws ConfigurationException {
        if (!(this.getRootNode() instanceof PListNode)) {
            this.initRoot();
        }
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("PropertyList-1.0.dtd"));
            }
        };
        XMLPropertyListHandler handler = new XMLPropertyListHandler(this.getRoot());
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.getXMLReader().setEntityResolver(resolver);
            parser.getXMLReader().setContentHandler(handler);
            parser.getXMLReader().parse(new InputSource(in));
        }
        catch (Exception e2) {
            throw new ConfigurationException("Unable to parse the configuration file", e2);
        }
    }

    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        if (this.getEncoding() != null) {
            writer.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        } else {
            writer.println("<?xml version=\"1.0\"?>");
        }
        writer.println("<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">");
        writer.println("<plist version=\"1.0\">");
        this.printNode(writer, 1, this.getRoot());
        writer.println("</plist>");
        writer.flush();
    }

    private void printNode(PrintWriter out, int indentLevel, HierarchicalConfiguration.Node node) {
        List children;
        String padding = StringUtils.repeat(" ", indentLevel * 4);
        if (node.getName() != null) {
            out.println(padding + "<key>" + StringEscapeUtils.escapeXml(node.getName()) + "</key>");
        }
        if (!(children = node.getChildren()).isEmpty()) {
            out.println(padding + "<dict>");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                HierarchicalConfiguration.Node child = (HierarchicalConfiguration.Node)it.next();
                this.printNode(out, indentLevel + 1, child);
                if (!it.hasNext()) continue;
                out.println();
            }
            out.println(padding + "</dict>");
        } else if (node.getValue() == null) {
            out.println(padding + "<dict/>");
        } else {
            Object value = node.getValue();
            this.printValue(out, indentLevel, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printValue(PrintWriter out, int indentLevel, Object value) {
        String padding = StringUtils.repeat(" ", indentLevel * 4);
        if (value instanceof Date) {
            DateFormat dateFormat = PListNode.format;
            synchronized (dateFormat) {
                out.println(padding + "<date>" + PListNode.format.format((Date)value) + "</date>");
            }
        } else if (value instanceof Calendar) {
            this.printValue(out, indentLevel, ((Calendar)value).getTime());
        } else if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                out.println(padding + "<real>" + value.toString() + "</real>");
            } else {
                out.println(padding + "<integer>" + value.toString() + "</integer>");
            }
        } else if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                out.println(padding + "<true/>");
            } else {
                out.println(padding + "<false/>");
            }
        } else if (value instanceof List) {
            out.println(padding + "<array>");
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                this.printValue(out, indentLevel + 1, it.next());
            }
            out.println(padding + "</array>");
        } else if (value instanceof HierarchicalConfiguration) {
            this.printNode(out, indentLevel, ((HierarchicalConfiguration)value).getRoot());
        } else if (value instanceof Configuration) {
            out.println(padding + "<dict>");
            Configuration config = (Configuration)value;
            Iterator it = config.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(key);
                node.setValue(config.getProperty(key));
                this.printNode(out, indentLevel + 1, node);
                if (!it.hasNext()) continue;
                out.println();
            }
            out.println(padding + "</dict>");
        } else if (value instanceof Map) {
            Map map = (Map)value;
            this.printValue(out, indentLevel, new MapConfiguration(map));
        } else if (value instanceof byte[]) {
            String base64 = new String(Base64.encodeBase64((byte[])((byte[])value)));
            out.println(padding + "<data>" + StringEscapeUtils.escapeXml(base64) + "</data>");
        } else if (value != null) {
            out.println(padding + "<string>" + StringEscapeUtils.escapeXml(String.valueOf(value)) + "</string>");
        } else {
            out.println(padding + "<string/>");
        }
    }

    private void initRoot() {
        this.setRootNode(new PListNode());
    }

    public static class ArrayNode
    extends PListNode {
        private static final long serialVersionUID = 5586544306664205835L;
        private List list = new ArrayList();

        public void addValue(Object value) {
            this.list.add(value);
        }

        public Object getValue() {
            return this.list;
        }
    }

    public static class PListNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -7614060264754798317L;
        private static DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        private static DateFormat gnustepFormat;

        public void addValue(Object value) {
            if (this.getValue() == null) {
                this.setValue(value);
            } else if (this.getValue() instanceof Collection) {
                Collection collection = (Collection)this.getValue();
                collection.add(value);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(this.getValue());
                list.add(value);
                this.setValue(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDateValue(String value) {
            block9: {
                try {
                    if (value.indexOf(32) != -1) {
                        DateFormat dateFormat = gnustepFormat;
                        synchronized (dateFormat) {
                            this.addValue(gnustepFormat.parse(value));
                            break block9;
                        }
                    }
                    DateFormat dateFormat = format;
                    synchronized (dateFormat) {
                        this.addValue(format.parse(value));
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }

        public void addDataValue(String value) {
            this.addValue(Base64.decodeBase64((byte[])value.getBytes()));
        }

        public void addIntegerValue(String value) {
            this.addValue(new BigInteger(value));
        }

        public void addRealValue(String value) {
            this.addValue(new BigDecimal(value));
        }

        public void addTrueValue() {
            this.addValue(Boolean.TRUE);
        }

        public void addFalseValue() {
            this.addValue(Boolean.FALSE);
        }

        public void addList(ArrayNode node) {
            this.addValue(node.getValue());
        }

        static {
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            gnustepFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        }
    }

    private static class XMLPropertyListHandler
    extends DefaultHandler {
        private StringBuffer buffer = new StringBuffer();
        private List stack = new ArrayList();

        public XMLPropertyListHandler(HierarchicalConfiguration.Node root) {
            this.push(root);
        }

        private HierarchicalConfiguration.Node peek() {
            if (!this.stack.isEmpty()) {
                return (HierarchicalConfiguration.Node)this.stack.get(this.stack.size() - 1);
            }
            return null;
        }

        private HierarchicalConfiguration.Node pop() {
            if (!this.stack.isEmpty()) {
                return (HierarchicalConfiguration.Node)this.stack.remove(this.stack.size() - 1);
            }
            return null;
        }

        private void push(HierarchicalConfiguration.Node node) {
            this.stack.add(node);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("array".equals(qName)) {
                this.push(new ArrayNode());
            } else if ("dict".equals(qName) && this.peek() instanceof ArrayNode) {
                XMLPropertyListConfiguration config = new XMLPropertyListConfiguration();
                ArrayNode node = (ArrayNode)this.peek();
                node.addValue(config);
                this.push(config.getRoot());
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("key".equals(qName)) {
                PListNode node = new PListNode();
                node.setName(this.buffer.toString());
                this.peek().addChild(node);
                this.push(node);
            } else if ("dict".equals(qName)) {
                this.pop();
            } else {
                if ("string".equals(qName)) {
                    ((PListNode)this.peek()).addValue(this.buffer.toString());
                } else if ("integer".equals(qName)) {
                    ((PListNode)this.peek()).addIntegerValue(this.buffer.toString());
                } else if ("real".equals(qName)) {
                    ((PListNode)this.peek()).addRealValue(this.buffer.toString());
                } else if ("true".equals(qName)) {
                    ((PListNode)this.peek()).addTrueValue();
                } else if ("false".equals(qName)) {
                    ((PListNode)this.peek()).addFalseValue();
                } else if ("data".equals(qName)) {
                    ((PListNode)this.peek()).addDataValue(this.buffer.toString());
                } else if ("date".equals(qName)) {
                    ((PListNode)this.peek()).addDateValue(this.buffer.toString());
                } else if ("array".equals(qName)) {
                    ArrayNode array = (ArrayNode)this.pop();
                    ((PListNode)this.peek()).addList(array);
                }
                if (!(this.peek() instanceof ArrayNode)) {
                    this.pop();
                }
            }
            this.buffer.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }
    }
}

