/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class AbandonedObjectPool
extends GenericObjectPool {
    private AbandonedConfig config = null;
    private List trace = new ArrayList();

    public AbandonedObjectPool(PoolableObjectFactory factory, AbandonedConfig config) {
        super(factory);
        this.config = config;
        System.out.println("AbandonedObjectPool is used (" + this + ")");
        System.out.println("   LogAbandoned: " + config.getLogAbandoned());
        System.out.println("   RemoveAbandoned: " + config.getRemoveAbandoned());
        System.out.println("   RemoveAbandonedTimeout: " + config.getRemoveAbandonedTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        Object obj;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((obj = super.borrowObject()) instanceof AbandonedTrace) {
            ((AbandonedTrace)obj).setStackTrace();
        }
        if (obj != null && this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.add(obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean foundObject = this.trace.remove(obj);
                if (!foundObject) {
                    return;
                }
            }
        }
        super.returnObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean foundObject = this.trace.remove(obj);
                if (!foundObject) {
                    return;
                }
            }
        }
        super.invalidateObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        long now2 = System.currentTimeMillis();
        long timeout = now2 - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<AbandonedTrace> remove = new ArrayList<AbandonedTrace>();
        List list = this.trace;
        synchronized (list) {
            Iterator it = this.trace.iterator();
            while (it.hasNext()) {
                AbandonedTrace pc = (AbandonedTrace)it.next();
                if (pc.getLastUsed() > timeout || pc.getLastUsed() <= 0L) continue;
                remove.add(pc);
            }
        }
        Iterator it = remove.iterator();
        while (it.hasNext()) {
            AbandonedTrace pc = (AbandonedTrace)it.next();
            if (this.config.getLogAbandoned()) {
                pc.printStackTrace();
            }
            try {
                this.invalidateObject(pc);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

