/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import java.util.HashMap;
import org.apache.xerces.impl.dtd.models.CMAny;
import org.apache.xerces.impl.dtd.models.CMBinOp;
import org.apache.xerces.impl.dtd.models.CMLeaf;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.dtd.models.CMUniOp;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class DFAContentModel
implements ContentModelValidator {
    private static String fEpsilonString = "<<CMNODE_EPSILON>>";
    private static String fEOCString = "<<CMNODE_EOC>>";
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fMixed;
    private int fEOCPos = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private final QName fQName = new QName();

    public DFAContentModel(CMNode cMNode, int n, boolean bl) {
        this.fLeafCount = n;
        this.fMixed = bl;
        this.buildDFA(cMNode);
    }

    public int validate(QName[] qNameArray, int n, int n2) {
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            QName qName = qNameArray[n + n5];
            if (!this.fMixed || qName.localpart != null) {
                int n6 = 0;
                while (n6 < this.fElemMapSize) {
                    String string;
                    int n7 = this.fElemMapType[n6] & 0xF;
                    if (n7 == 0 ? this.fElemMap[n6].rawname == qName.rawname : (n7 == 6 ? (string = this.fElemMap[n6].uri) == null || string == qName.uri : (n7 == 8 ? qName.uri == null : n7 == 7 && this.fElemMap[n6].uri != qName.uri))) break;
                    ++n6;
                }
                if (n6 == this.fElemMapSize) {
                    return n5;
                }
                if ((n4 = this.fTransTable[n4][n6]) == -1) {
                    return n5;
                }
            }
            ++n5;
        }
        if (!this.fFinalStateFlags[n4]) {
            return n2;
        }
        return -1;
    }

    private void buildDFA(CMNode cMNode) {
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        this.fQName.setValues(null, fEOCString, fEOCString, null);
        CMLeaf cMLeaf = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n4 = 0;
        while (n4 < this.fLeafCount) {
            this.fFollowList[n4] = new CMStateSet(this.fLeafCount);
            ++n4;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int n5 = 0;
        while (n5 < this.fLeafCount) {
            this.fElemMap[n5] = new QName();
            object3 = this.fLeafList[n5].getElement();
            n2 = 0;
            while (n2 < this.fElemMapSize) {
                if (this.fElemMap[n2].rawname == object3.rawname) break;
                ++n2;
            }
            if (n2 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues((QName)object3);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n5];
                ++this.fElemMapSize;
            }
            ++n5;
        }
        object3 = new int[this.fLeafCount + this.fElemMapSize];
        n2 = 0;
        int n6 = 0;
        while (n6 < this.fElemMapSize) {
            n = 0;
            while (n < this.fLeafCount) {
                object2 = this.fLeafList[n].getElement();
                object = this.fElemMap[n6];
                if (object2.rawname == ((QName)object).rawname) {
                    object3[n2++] = n;
                }
                ++n;
            }
            object3[n2++] = -1;
            ++n6;
        }
        n = this.fLeafCount * 4;
        object2 = new CMStateSet[n];
        this.fFinalStateFlags = new boolean[n];
        this.fTransTable = new int[n][];
        object = this.fHeadNode.firstPos();
        int n7 = 0;
        int n8 = 0;
        this.fTransTable[n8] = this.makeDefStateList();
        object2[n8] = object;
        ++n8;
        HashMap<CMStateSet, Integer> hashMap = new HashMap<CMStateSet, Integer>();
        while (n7 < n8) {
            object = object2[n7];
            int[] nArray = this.fTransTable[n7];
            this.fFinalStateFlags[n7] = ((CMStateSet)object).getBit(this.fEOCPos);
            ++n7;
            CMStateSet cMStateSet = null;
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.fElemMapSize) {
                if (cMStateSet == null) {
                    cMStateSet = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet.zeroBits();
                }
                int n11 = object3[n9++];
                while (n11 != -1) {
                    if (((CMStateSet)object).getBit(n11)) {
                        cMStateSet.union(this.fFollowList[n11]);
                    }
                    n11 = object3[n9++];
                }
                if (!cMStateSet.isEmpty()) {
                    int n12;
                    Integer n13 = (Integer)hashMap.get(cMStateSet);
                    int n14 = n12 = n13 == null ? n8 : n13;
                    if (n12 == n8) {
                        object2[n8] = cMStateSet;
                        this.fTransTable[n8] = this.makeDefStateList();
                        hashMap.put(cMStateSet, new Integer(n8));
                        ++n8;
                        cMStateSet = null;
                    }
                    nArray[n10] = n12;
                    if (n8 == n) {
                        int n15 = (int)((double)n * 1.5);
                        CMStateSet[] cMStateSetArray = new CMStateSet[n15];
                        boolean[] blArray = new boolean[n15];
                        int[][] nArrayArray = new int[n15][];
                        System.arraycopy(object2, 0, cMStateSetArray, 0, n);
                        System.arraycopy(this.fFinalStateFlags, 0, blArray, 0, n);
                        System.arraycopy(this.fTransTable, 0, nArrayArray, 0, n);
                        n = n15;
                        object2 = cMStateSetArray;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArrayArray;
                    }
                }
                ++n10;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 2 || cMNode.type() == 3) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 1) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        int n4 = cMNode.type();
        if (n4 == 4 || n4 == 5) {
            if (n4 == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMBinOp)cMNode).getLeft(), n + 1);
            this.dumpTree(((CMBinOp)cMNode).getRight(), n + 1);
        } else if (cMNode.type() == 2) {
            System.out.print("Rep Node ");
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMUniOp)cMNode).getChild(), n + 1);
        } else if (cMNode.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + ((CMLeaf)cMNode).getElement() + "(elemIndex=" + ((CMLeaf)cMNode).getElement() + ") ");
            if (cMNode.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n) {
        cMNode.setMaxStates(this.fLeafCount);
        if ((cMNode.type() & 0xF) == 6 || (cMNode.type() & 0xF) == 8 || (cMNode.type() & 0xF) == 7) {
            QName qName = new QName(null, null, null, ((CMAny)cMNode).getURI());
            this.fLeafList[n] = new CMLeaf(qName, ((CMAny)cMNode).getPosition());
            this.fLeafListType[n] = cMNode.type();
            ++n;
        } else if (cMNode.type() == 4 || cMNode.type() == 5) {
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 2 || cMNode.type() == 3 || cMNode.type() == 1) {
            n = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 0) {
            QName qName = ((CMLeaf)cMNode).getElement();
            if (qName.localpart != fEpsilonString) {
                this.fLeafList[n] = (CMLeaf)cMNode;
                this.fLeafListType[n] = 0;
                ++n;
            }
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM: type=" + cMNode.type());
        }
        return n;
    }

    static {
        fEpsilonString = fEpsilonString.intern();
        fEOCString = fEOCString.intern();
    }
}

