/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.DoubleDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.xs.datatypes.XSFloat;

public class FloatDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2552;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "float"});
        }
    }

    public int compare(Object object, Object object2) {
        return ((XFloat)object).compareTo((XFloat)object2);
    }

    public boolean isIdentical(Object object, Object object2) {
        if (object2 instanceof XFloat) {
            return ((XFloat)object).isIdentical((XFloat)object2);
        }
        return false;
    }

    private static final class XFloat
    implements XSFloat {
        private final float value;
        private String canonical;

        public XFloat(String string) throws NumberFormatException {
            if (DoubleDV.isPossibleFP(string)) {
                this.value = Float.parseFloat(string);
            } else if (string.equals("INF")) {
                this.value = Float.POSITIVE_INFINITY;
            } else if (string.equals("-INF")) {
                this.value = Float.NEGATIVE_INFINITY;
            } else if (string.equals("NaN")) {
                this.value = Float.NaN;
            } else {
                throw new NumberFormatException(string);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XFloat)) {
                return false;
            }
            XFloat xFloat = (XFloat)object;
            if (this.value == xFloat.value) {
                return true;
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        public int hashCode() {
            return this.value == 0.0f ? 0 : Float.floatToIntBits(this.value);
        }

        public boolean isIdentical(XFloat xFloat) {
            if (xFloat == this) {
                return true;
            }
            if (this.value == xFloat.value) {
                return this.value != 0.0f || Float.floatToIntBits(this.value) == Float.floatToIntBits(xFloat.value);
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        private int compareTo(XFloat xFloat) {
            float f = xFloat.value;
            if (this.value < f) {
                return -1;
            }
            if (this.value > f) {
                return 1;
            }
            if (this.value == f) {
                return 0;
            }
            if (this.value != this.value) {
                if (f != f) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                if (this.value == Float.POSITIVE_INFINITY) {
                    this.canonical = "INF";
                } else if (this.value == Float.NEGATIVE_INFINITY) {
                    this.canonical = "-INF";
                } else if (this.value != this.value) {
                    this.canonical = "NaN";
                } else if (this.value == 0.0f) {
                    this.canonical = "0.0E1";
                } else {
                    this.canonical = Float.toString(this.value);
                    if (this.canonical.indexOf(69) == -1) {
                        int n;
                        int n2 = this.canonical.length();
                        char[] cArray = new char[n2 + 3];
                        this.canonical.getChars(0, n2, cArray, 0);
                        int n4 = n = cArray[0] == '-' ? 2 : 1;
                        if (this.value >= 1.0f || this.value <= -1.0f) {
                            int n5;
                            int n6 = n5 = this.canonical.indexOf(46);
                            while (n6 > n) {
                                cArray[n6] = cArray[n6 - 1];
                                --n6;
                            }
                            cArray[n] = 46;
                            while (cArray[n2 - 1] == '0') {
                                --n2;
                            }
                            if (cArray[n2 - 1] == '.') {
                                // empty if block
                            }
                            int n7 = ++n2;
                            cArray[n7] = 69;
                            int n8 = n5 - n;
                            int n9 = ++n2;
                            ++n2;
                            cArray[n9] = (char)(n8 + 48);
                        } else {
                            int n10 = n + 1;
                            while (cArray[n10] == '0') {
                                ++n10;
                            }
                            cArray[n - 1] = cArray[n10];
                            cArray[n] = 46;
                            int n11 = n10 + 1;
                            int n12 = n + 1;
                            while (n11 < n2) {
                                cArray[n12] = cArray[n11];
                                ++n11;
                                ++n12;
                            }
                            if ((n2 -= n10 - n) == n + 1) {
                                cArray[n2++] = 48;
                            }
                            cArray[n2++] = 69;
                            cArray[n2++] = 45;
                            int n13 = n10 - n;
                            cArray[n2++] = (char)(n13 + 48);
                        }
                        this.canonical = new String(cArray, 0, n2);
                    }
                }
            }
            return this.canonical;
        }

        public float getValue() {
            return this.value;
        }
    }
}

