/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UCSReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final short UCS2LE = 1;
    public static final short UCS2BE = 2;
    public static final short UCS4LE = 4;
    public static final short UCS4BE = 8;
    protected final InputStream fInputStream;
    protected final byte[] fBuffer;
    protected final short fEncoding;

    public UCSReader(InputStream inputStream, short s) {
        this(inputStream, 8192, s);
    }

    public UCSReader(InputStream inputStream, int n, short s) {
        this(inputStream, new byte[n], s);
    }

    public UCSReader(InputStream inputStream, byte[] byArray, short s) {
        this.fInputStream = inputStream;
        this.fBuffer = byArray;
        this.fEncoding = s;
    }

    public int read() throws IOException {
        int n = this.fInputStream.read() & 0xFF;
        if (n == 255) {
            return -1;
        }
        int n2 = this.fInputStream.read() & 0xFF;
        if (n2 == 255) {
            return -1;
        }
        if (this.fEncoding >= 4) {
            int n4 = this.fInputStream.read() & 0xFF;
            if (n4 == 255) {
                return -1;
            }
            int n5 = this.fInputStream.read() & 0xFF;
            if (n5 == 255) {
                return -1;
            }
            if (this.fEncoding == 8) {
                return (n << 24) + (n2 << 16) + (n4 << 8) + n5;
            }
            return (n5 << 24) + (n4 << 16) + (n2 << 8) + n;
        }
        if (this.fEncoding == 2) {
            return (n << 8) + n2;
        }
        return (n2 << 8) + n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n2 << (this.fEncoding >= 4 ? 2 : 1);
        if (n9 > this.fBuffer.length) {
            n9 = this.fBuffer.length;
        }
        if ((n8 = this.fInputStream.read(this.fBuffer, 0, n9)) == -1) {
            return -1;
        }
        if (this.fEncoding >= 4) {
            n7 = 4 - (n8 & 3) & 3;
            n6 = 0;
            while (n6 < n7) {
                n5 = this.fInputStream.read();
                if (n5 == -1) {
                    n4 = n6;
                    while (n4 < n7) {
                        this.fBuffer[n8 + n4] = 0;
                        ++n4;
                    }
                    break;
                }
                this.fBuffer[n8 + n6] = (byte)n5;
                ++n6;
            }
            n8 += n7;
        } else {
            n7 = n8 & 1;
            if (n7 != 0) {
                ++n8;
                n6 = this.fInputStream.read();
                this.fBuffer[n8] = n6 == -1 ? (byte)0 : (byte)n6;
            }
        }
        n7 = n8 >> (this.fEncoding >= 4 ? 2 : 1);
        n6 = 0;
        n5 = 0;
        while (n5 < n7) {
            n4 = this.fBuffer[n6++] & 0xFF;
            int n10 = this.fBuffer[n6++] & 0xFF;
            if (this.fEncoding >= 4) {
                int n11 = this.fBuffer[n6++] & 0xFF;
                int n12 = this.fBuffer[n6++] & 0xFF;
                cArray[n + n5] = this.fEncoding == 8 ? (char)((n4 << 24) + (n10 << 16) + (n11 << 8) + n12) : (char)((n12 << 24) + (n11 << 16) + (n10 << 8) + n4);
            } else {
                cArray[n + n5] = this.fEncoding == 2 ? (char)((n4 << 8) + n10) : (char)((n10 << 8) + n4);
            }
            ++n5;
        }
        return n7;
    }

    public long skip(long l) throws IOException {
        int n = this.fEncoding >= 4 ? 2 : 1;
        long l2 = this.fInputStream.skip(l << n);
        if ((l2 & (long)(n | 1)) == 0L) {
            return l2 >> n;
        }
        return (l2 >> n) + 1L;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    public void mark(int n) throws IOException {
        this.fInputStream.mark(n);
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }
}

