/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;

public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "zip";

    protected Iterator getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        final ZipFile zipFile = new ZipFile(f);
        final Enumeration en = zipFile.getEntries();
        return new Iterator(){

            public boolean hasNext() {
                return en.hasMoreElements();
            }

            public Object next() {
                ZipEntry entry = (ZipEntry)en.nextElement();
                ZipResource res = new ZipResource(zipFile, entry);
                return res;
            }

            public void remove() {
                throw new UnsupportedOperationException("Removing isn't implemented.");
            }
        };
    }
}

