/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.v2.impl;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.ldap.NodeFacade;
import org.dataone.cn.quartz.CronExpression;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.v2.NodeRegistryService;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;

public class NodeRegistryServiceImpl
implements NodeRegistryService {
    public static Log log = LogFactory.getLog(NodeRegistryServiceImpl.class);
    private NodeFacade nodeFacade = new NodeFacade();
    static Pattern excludeNodeBaseURLPattern = Pattern.compile("^https?\\:\\/\\/(?:(?:localhost(?:\\:8080)?\\/)|(?:127\\.0)).+");
    static Pattern validNodeIdPattern = Pattern.compile(Settings.getConfiguration().getString("cn.nodeId.validation"));
    private long lastNodelistRefreshTimeMS = 0L;
    static final long NODELIST_REFRESH_INTERVAL_MS = Settings.getConfiguration().getLong("noderegistry.nodeListRefreshInterval", 3L) * 1000L;
    static final long NODE_REFRESH_INTERVAL_MS = Settings.getConfiguration().getLong("noderegistry.nodeRefreshInterval", 3L) * 1000L;
    NodeList nodeList = null;
    Map<NodeReference, Long> nodeRefreshDateMap = new ConcurrentHashMap<NodeReference, Long>();
    Map<NodeReference, Node> nodeCacheMap = new ConcurrentHashMap<NodeReference, Node>();

    @Override
    public synchronized NodeList listNodes() throws NotImplemented, ServiceFailure {
        if (this.nodeList == null || this.isTimeForNodelistRefresh().booleanValue()) {
            this.nodeList = this.nodeFacade.getApprovedNodeList();
        }
        return this.nodeList;
    }

    @Override
    public NodeList listPendingNodes() throws NotImplemented, ServiceFailure, NotFound {
        NodeList pendingNodeList = new NodeList();
        List<NodeReference> pendingReferenceNodeList = this.nodeFacade.getPendingNodeReferenceList();
        for (NodeReference nodeReference : pendingReferenceNodeList) {
            Node node = this.getNodeCapabilities(nodeReference);
            pendingNodeList.addNode(node);
        }
        return pendingNodeList;
    }

    @Override
    public synchronized Node getNodeCapabilities(NodeReference nodeReference) throws ServiceFailure, NotFound {
        Node node = null;
        if (!this.nodeCacheMap.containsKey(nodeReference) || this.isTimeForNodeRefresh(nodeReference).booleanValue()) {
            node = this.nodeFacade.getNode(nodeReference);
            this.nodeCacheMap.put(nodeReference, node);
        }
        if ((node = this.nodeCacheMap.get(nodeReference)) == null) {
            throw new ServiceFailure("4803", "could not retrieve " + nodeReference.getValue() + " from nodeCacheMap");
        }
        return node;
    }

    @Override
    public NodeReference register(Node node) throws ServiceFailure, InvalidRequest, IdentifierNotUnique, NotImplemented {
        Matcher httpPatternMatcher = excludeNodeBaseURLPattern.matcher(node.getBaseURL());
        if (httpPatternMatcher.find()) {
            throw new InvalidRequest("4823", "BaseURL may not point to localhost! " + node.getBaseURL());
        }
        Matcher validNodeIdMatcher = validNodeIdPattern.matcher(node.getIdentifier().getValue());
        if (!validNodeIdMatcher.matches()) {
            throw new InvalidRequest("4823", "Problem registring " + node.getIdentifier().getValue() + "-" + Settings.getConfiguration().getString("cn.nodeId.validation.errorText"));
        }
        String newNodeId = node.getIdentifier().getValue();
        String newBaseUrl = node.getBaseURL();
        Map<String, String> nodeIds = this.nodeFacade.getNodeIdList();
        if (nodeIds.containsKey(newNodeId)) {
            IdentifierNotUnique ex = new IdentifierNotUnique("4844", node.getIdentifier().getValue() + " is not available for registration");
            throw ex;
        }
        if (nodeIds.containsValue(newBaseUrl)) {
            String offendingNodeId = "";
            for (String nodeId : nodeIds.keySet()) {
                if (!nodeIds.get(nodeId).equals(newBaseUrl)) continue;
                offendingNodeId = nodeId;
                break;
            }
            throw new InvalidRequest("4823", "BaseURL " + newBaseUrl + " used by another node " + offendingNodeId);
        }
        try {
            if (node.isSynchronize()) {
                this.validateSynchronizationSchedule(node);
            }
            this.nodeFacade.createNode(node);
            return node.getIdentifier();
        }
        catch (ServiceFailure ex) {
            ex.setDetail_code("4842");
            throw ex;
        }
        catch (InvalidRequest ex) {
            ex.setDetail_code("4843");
            throw ex;
        }
        catch (NotImplemented ex) {
            ex.setDetail_code("4820");
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("Problem registering node " + node.getName(), ex);
            throw new ServiceFailure("4842", ex.getMessage());
        }
    }

    @Override
    public boolean updateNodeCapabilities(NodeReference nodeid, Node node) throws NotImplemented, ServiceFailure, InvalidRequest, NotFound {
        Matcher httpPatternMatcher = excludeNodeBaseURLPattern.matcher(node.getBaseURL());
        if (httpPatternMatcher.find()) {
            throw new InvalidRequest("4823", "BaseURL may not point to localhost! " + node.getBaseURL());
        }
        try {
            if (node.isSynchronize()) {
                this.validateSynchronizationSchedule(node);
            }
            this.nodeFacade.updateNode(node);
            this.setLastNodelistRefreshTimeMS(this.getLastNodelistRefreshTimeMS() - NODELIST_REFRESH_INTERVAL_MS);
            if (this.nodeRefreshDateMap.containsKey(nodeid)) {
                this.nodeRefreshDateMap.put(nodeid, this.nodeRefreshDateMap.get(nodeid) - NODE_REFRESH_INTERVAL_MS);
            }
            return true;
        }
        catch (ServiceFailure ex) {
            ex.setDetail_code("4822");
            throw ex;
        }
        catch (InvalidRequest ex) {
            ex.setDetail_code("4823");
            throw ex;
        }
        catch (NotFound ex) {
            ex.setDetail_code("4824");
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("Problem registering node " + node.getName(), ex);
            throw new ServiceFailure("4842", ex.getMessage());
        }
    }

    @Override
    public void deleteNode(NodeReference nodeReference) throws ServiceFailure {
        this.nodeFacade.deleteNode(nodeReference);
    }

    @Override
    public void approveNode(NodeReference nodeReference) throws ServiceFailure {
        this.nodeFacade.setNodeApproved(nodeReference, Boolean.TRUE);
    }

    private void validateSynchronizationSchedule(Node node) throws InvalidRequest {
        if (node.getSynchronization() == null) {
            throw new InvalidRequest("-1", "If the node has synchronization attribute set to true, then the node should include the Synchronization element");
        }
        String seconds = node.getSynchronization().getSchedule().getSec().replace(" ", "");
        String minutes = node.getSynchronization().getSchedule().getMin().replace(" ", "");
        String hours = node.getSynchronization().getSchedule().getHour().replace(" ", "");
        String dayOfMonth = node.getSynchronization().getSchedule().getMday().replace(" ", "");
        String month = node.getSynchronization().getSchedule().getMon().replace(" ", "");
        String dayOfWeek = node.getSynchronization().getSchedule().getWday().replace(" ", "");
        String year = node.getSynchronization().getSchedule().getYear().replace(" ", "");
        try {
            Integer secondsInteger = Integer.parseInt(seconds);
            if (secondsInteger == null || secondsInteger < 0 || secondsInteger >= 60) {
                throw new InvalidRequest("-1", "seconds:" + seconds + " must be between 0 and 59");
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidRequest("-1", "seconds:" + seconds + " must be an integer between 0 and 59");
        }
        String crontabExpression = seconds + " " + minutes + " " + hours + " " + dayOfMonth + " " + month + " " + dayOfWeek + " " + year;
        if (!CronExpression.isValidExpression(crontabExpression)) {
            throw new InvalidRequest("-1", "Not a valid synchronization schedule");
        }
    }

    private Boolean isTimeForNodelistRefresh() {
        Date now2 = new Date();
        long nowMS = now2.getTime();
        DateFormat df = DateFormat.getDateTimeInstance();
        df.format(now2);
        if (nowMS - this.getLastNodelistRefreshTimeMS() > NODELIST_REFRESH_INTERVAL_MS) {
            this.setLastNodelistRefreshTimeMS(nowMS);
            log.info("  nodelist refresh: new cached time: " + df.format(now2));
            return true;
        }
        return false;
    }

    private Boolean isTimeForNodeRefresh(NodeReference nodeReference) {
        Date now2 = new Date();
        Long nowMS = new Long(now2.getTime());
        DateFormat df = DateFormat.getDateTimeInstance();
        df.format(now2);
        if (!this.nodeRefreshDateMap.containsKey(nodeReference)) {
            this.nodeRefreshDateMap.put(nodeReference, nowMS);
            log.info("node initial refresh: new cached time: " + df.format(now2));
            return true;
        }
        if (nowMS - this.nodeRefreshDateMap.get(nodeReference) > NODELIST_REFRESH_INTERVAL_MS) {
            this.nodeRefreshDateMap.put(nodeReference, nowMS);
            log.info("node refresh: new cached time: " + df.format(now2));
            return true;
        }
        return false;
    }

    private long getLastNodelistRefreshTimeMS() {
        return this.lastNodelistRefreshTimeMS;
    }

    private synchronized void setLastNodelistRefreshTimeMS(long lastNodelistRefreshTimeMS) {
        this.lastNodelistRefreshTimeMS = lastNodelistRefreshTimeMS;
    }
}

