/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.handler.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.solr.handler.component.SolrSearchHandlerUtil;

public class SolrLoggingHandler
extends SearchHandler {
    private static final String READ_PERMISSION_FIELD = "readPermission";
    private static Log logger = LogFactory.getLog(SolrLoggingHandler.class);

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception, InstantiationException, IllegalAccessException {
        HttpServletRequest httpServletRequest = null;
        boolean isFacetedQuery = false;
        if (req.getContext().containsKey("httpRequest")) {
            httpServletRequest = (HttpServletRequest)req.getContext().get("httpRequest");
            if (httpServletRequest == null) {
                SolrSearchHandlerUtil.logSolrContext(req);
                throw new ServiceFailure("1490", "Solr misconfigured. Context should have the request");
            }
        } else {
            SolrSearchHandlerUtil.logSolrContext(req);
            throw new ServiceFailure("1490", "Solr misconfigured. Context should have the request");
        }
        String[] isMNAdministrator = httpServletRequest.getParameterValues("isMnAdministrator");
        String[] isCNAdministrator = httpServletRequest.getParameterValues("isCnAdministrator");
        String[] authorizedSubjects = httpServletRequest.getParameterValues("authorizedSubjects");
        SolrParams requestParams = req.getParams();
        HashMap<String, String[]> convertedSolrParams = SolrSearchHandlerUtil.getConvertedParameters(requestParams);
        SolrSearchHandlerUtil.logSolrParameters(convertedSolrParams);
        if (convertedSolrParams.containsKey("facet")) {
            for (int i = 0; i < convertedSolrParams.get("facet").length; ++i) {
                String value = convertedSolrParams.get("facet")[i];
                if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("on")) continue;
                isFacetedQuery = true;
            }
        }
        if (isFacetedQuery) {
            SolrLoggingHandler.replaceParam("rows", "0", convertedSolrParams);
            if (convertedSolrParams.containsKey("facet.field")) {
                SolrLoggingHandler.removeParamValue("facet.field", "ipAddress", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.field", READ_PERMISSION_FIELD, convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.field", "subject", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.field", "rightsHolder", convertedSolrParams);
            }
            if (convertedSolrParams.containsKey("facet.query")) {
                SolrLoggingHandler.removeParamValue("facet.query", "ipAddress", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.query", READ_PERMISSION_FIELD, convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.query", "subject", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.query", "rightsHolder", convertedSolrParams);
            }
            if (convertedSolrParams.containsKey("facet.contains")) {
                SolrLoggingHandler.removeParamValue("facet.contains", "ipAddress", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.contains", READ_PERMISSION_FIELD, convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.contains", "subject", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.contains", "rightsHolder", convertedSolrParams);
            }
            if (convertedSolrParams.containsKey("facet.contains.ignoreCase")) {
                SolrLoggingHandler.removeParamValue("facet.contains.ignoreCase", "ipAddress", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.contains.ignoreCase", READ_PERMISSION_FIELD, convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.contains.ignoreCase", "subject", convertedSolrParams);
                SolrLoggingHandler.removeParamValue("facet.contains.ignoreCase", "rightsHolder", convertedSolrParams);
            }
            if (convertedSolrParams.containsKey("facet.prefix")) {
                convertedSolrParams.remove("facet.prefix");
            }
        } else if (SolrSearchHandlerUtil.isValidSolrParam(isMNAdministrator) || SolrSearchHandlerUtil.isValidSolrParam(isCNAdministrator) || SolrSearchHandlerUtil.isValidSolrParam(authorizedSubjects)) {
            if (SolrSearchHandlerUtil.isValidSolrParam(isCNAdministrator) && !SolrSearchHandlerUtil.isCNAdministrator(isCNAdministrator)) {
                throw new NotAuthorized("1460", "Invalid Coordinating Node token");
            }
            logger.debug("found an Valid authorized user mn? " + ArrayUtils.toString(isMNAdministrator) + " cn? " + ArrayUtils.toString(isCNAdministrator) + " is authsubject? " + ArrayUtils.toString(authorizedSubjects));
            SolrSearchHandlerUtil.applyRowRestrictions(requestParams, convertedSolrParams);
            SolrSearchHandlerUtil.applyReadRestrictionQueryFilterParameters(httpServletRequest, convertedSolrParams, READ_PERMISSION_FIELD);
            if (SolrSearchHandlerUtil.isValidSolrParam(isMNAdministrator) && !SolrSearchHandlerUtil.isCNAdministrator(isCNAdministrator)) {
                this.applyMNAdministratorRestriction(convertedSolrParams, isMNAdministrator[0]);
            }
        } else {
            SolrLoggingHandler.replaceParam("rows", "0", convertedSolrParams);
        }
        SolrSearchHandlerUtil.setNewSolrParameters(req, convertedSolrParams);
        SolrSearchHandlerUtil.logSolrParameters(convertedSolrParams);
        super.handleRequestBody(req, rsp);
    }

    private void applyMNAdministratorRestriction(HashMap<String, String[]> convertedSolrParams, String memberNodeId) {
        logger.debug("found an Membernode user");
        String mnFilterString = "nodeId:" + SolrSearchHandlerUtil.escapeQueryChars(memberNodeId);
        MultiMapSolrParams.addParam((String)"fq", (String)mnFilterString, convertedSolrParams);
    }

    public static void replaceParam(String name, String val, Map<String, String[]> map) {
        String[] arr = new String[]{val};
        map.put(name, arr);
    }

    public static void removeParamValue(String name, String val, Map<String, String[]> map) {
        if (map.containsKey(name)) {
            String[] arr = map.get(name);
            ArrayList<String> redactFromList = new ArrayList<String>(Arrays.asList(arr));
            ArrayList<String> redactFullEntryList = new ArrayList<String>();
            for (int i = 0; i < redactFromList.size(); ++i) {
                if (!redactFromList.get(i).contains(val)) continue;
                redactFullEntryList.add(redactFromList.get(i));
            }
            if (redactFromList.removeAll(redactFullEntryList)) {
                map.put(name, redactFromList.toArray(new String[0]));
            }
        }
    }
}

