/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.handler.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.solr.handler.component.SolrSearchHandlerUtil;

public class SolrSearchHandler
extends SearchHandler
implements SolrRequestHandler {
    private static final String READ_PERMISSION_FIELD = "readPermission";
    private static final String RIGHTS_HOLDER_FIELD = "rightsHolder";
    private static final String WRITE_PERMISSION_FIELD = "writePermission";
    private static final String CHANGE_PERMISSION_FIELD = "changePermission";
    private static List<String> readPermissionFields = new ArrayList<String>();
    private static Log logger;

    public void handleRequestBody(SolrQueryRequest request, SolrQueryResponse response) throws Exception, InstantiationException, IllegalAccessException {
        HttpServletRequest httpServletRequest = null;
        if (request.getContext().containsKey("httpRequest")) {
            httpServletRequest = (HttpServletRequest)request.getContext().get("httpRequest");
            if (httpServletRequest == null) {
                SolrSearchHandlerUtil.logSolrContext(request);
                throw new ServiceFailure("1490", "Solr misconfigured. Context should have the request");
            }
        } else {
            SolrSearchHandlerUtil.logSolrContext(request);
            throw new ServiceFailure("4310", "Solr misconfigured. Context should have the request");
        }
        SolrParams requestParams = request.getParams();
        HashMap<String, String[]> convertedSolrParams = SolrSearchHandlerUtil.getConvertedParameters(requestParams);
        SolrSearchHandlerUtil.applyRowRestrictions(requestParams, convertedSolrParams);
        convertedSolrParams.remove("d1-pc");
        this.disableMLTResults(convertedSolrParams);
        SolrSearchHandlerUtil.logSolrParameters(convertedSolrParams);
        SolrSearchHandlerUtil.applyReadRestrictionQueryFilterParameters(httpServletRequest, convertedSolrParams, readPermissionFields);
        SolrSearchHandlerUtil.setNewSolrParameters(request, convertedSolrParams);
        SolrSearchHandlerUtil.logSolrParameters(convertedSolrParams);
        logger.debug("Solr Search Handler query: " + request.getParams().get("q"));
        logger.debug("Solr Search Handler query filter: " + request.getParams().get("fq"));
        super.handleRequestBody(request, response);
    }

    private void disableMLTResults(HashMap<String, String[]> convertedSolrParams) {
        convertedSolrParams.remove("mlt");
        MultiMapSolrParams.addParam((String)"mlt", (String)"false", convertedSolrParams);
    }

    static {
        readPermissionFields.add(READ_PERMISSION_FIELD);
        readPermissionFields.add(RIGHTS_HOLDER_FIELD);
        readPermissionFields.add(WRITE_PERMISSION_FIELD);
        readPermissionFields.add(CHANGE_PERMISSION_FIELD);
        logger = LogFactory.getLog(SolrSearchHandler.class);
    }
}

