/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.handler.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.dataone.configuration.Settings;
import org.dataone.solr.handler.component.SolrLoggingHandler;

public class SolrSearchHandlerUtil {
    private static Log logger = LogFactory.getLog(SolrSearchHandlerUtil.class);
    private static String publicFilterString = "isPublic:true";
    private static String cnAdministratorToken = Settings.getConfiguration().getString("cn.solrAdministrator.token");
    public static final String CONTEXT_HTTP_REQUEST_KEY = "httpRequest";

    public static void applyReadRestrictionQueryFilterParameters(HttpServletRequest httpServletRequest, HashMap<String, String[]> convertedSolrParams, String readField) {
        ArrayList<String> readFields = new ArrayList<String>();
        readFields.add(readField);
        SolrSearchHandlerUtil.applyReadRestrictionQueryFilterParameters(httpServletRequest, convertedSolrParams, readFields);
    }

    public static void applyReadRestrictionQueryFilterParameters(HttpServletRequest httpServletRequest, HashMap<String, String[]> convertedSolrParams, List<String> readFields) {
        String[] isAdministrator = httpServletRequest.getParameterValues("isCnAdministrator");
        if (isAdministrator == null || isAdministrator.length == 0) {
            isAdministrator = httpServletRequest.getParameterValues("isMnAdministrator");
        }
        convertedSolrParams.remove("authorizedSubjects");
        if (SolrSearchHandlerUtil.isInvalidSolrParam(isAdministrator)) {
            logger.debug("not an administrative user");
            String[] authorizedSubjects = httpServletRequest.getParameterValues("authorizedSubjects");
            if (authorizedSubjects != null && authorizedSubjects.length > 0) {
                logger.debug("found an authorized user");
                ArrayList<String> authorizedSubjectList = new ArrayList<String>();
                for (int i = 0; i < authorizedSubjects.length; ++i) {
                    authorizedSubjectList.add("\"" + SolrSearchHandlerUtil.escapeQueryChars(authorizedSubjects[i]) + "\"");
                }
                StringBuffer readFqValue = new StringBuffer();
                readFqValue.append("(");
                Iterator<String> it = readFields.iterator();
                while (it.hasNext()) {
                    String readField = it.next();
                    readFqValue.append("(");
                    String readFieldString = readField + ":" + StringUtils.join(authorizedSubjectList, " OR " + readField + ":");
                    readFqValue.append(readFieldString);
                    readFqValue.append(")");
                    System.out.println("****SEARCH SECURITY - read string for single field: " + readFieldString);
                    System.out.println("****Search Security - full string: " + readFqValue.toString());
                    if (!it.hasNext()) continue;
                    readFqValue.append(" OR ");
                }
                readFqValue.append(")");
                System.out.println();
                logger.debug("**** Search security - full read permission string: " + readFqValue.toString());
                MultiMapSolrParams.addParam((String)"fq", (String)readFqValue.toString(), convertedSolrParams);
            } else {
                logger.debug("found a public user");
                MultiMapSolrParams.addParam((String)"fq", (String)publicFilterString, convertedSolrParams);
            }
        } else if (!SolrSearchHandlerUtil.isValidSolrParam(isAdministrator)) {
            MultiMapSolrParams.addParam((String)"fq", (String)publicFilterString, convertedSolrParams);
            logger.warn("an invalid administrative user got passed initial verification in SessionAuthorizationFilter admin token: " + isAdministrator[0]);
        }
    }

    public static void applyRowRestrictions(SolrParams requestParams, HashMap<String, String[]> convertedSolrParams) {
        String[] rows = requestParams.getParams("rows");
        if (rows != null) {
            try {
                for (int i = 0; i < rows.length; ++i) {
                    if (Integer.parseInt(rows[i]) <= 10000) continue;
                    SolrLoggingHandler.replaceParam("rows", "10000", convertedSolrParams);
                }
            }
            catch (NumberFormatException ex) {
                SolrLoggingHandler.replaceParam("rows", "1000", convertedSolrParams);
            }
        }
    }

    public static boolean isValidSolrParam(String[] solrParam) {
        return solrParam != null && solrParam.length > 0 && StringUtils.isNotEmpty(solrParam[0]);
    }

    public static boolean isCNAdministrator(String[] isAdministrator) {
        return isAdministrator != null && isAdministrator.length > 0 && StringUtils.isNotEmpty(cnAdministratorToken) && cnAdministratorToken.equals(isAdministrator[0]);
    }

    private static boolean isInvalidSolrParam(String[] solrParam) {
        return solrParam == null || solrParam.length == 0;
    }

    public static void logSolrContext(SolrQueryRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug("logging solr query request context keys:");
            for (Object key : req.getContext().keySet()) {
                logger.debug("key: " + key.toString());
                logger.debug("value: " + req.getContext().get(key).toString());
            }
        }
    }

    public static void logSolrParameters(HashMap<String, String[]> convertedSolrParams) {
        if (logger.isDebugEnabled()) {
            for (String key : convertedSolrParams.keySet()) {
                logger.debug("key : " + key);
                for (int i = 0; i < convertedSolrParams.get(key).length; ++i) {
                    String value = convertedSolrParams.get(key)[i];
                    logger.debug("value: " + value);
                }
            }
        }
    }

    public static HashMap<String, String[]> getConvertedParameters(SolrParams solrParams) {
        HashMap<String, String[]> convertedSolrParams = new HashMap<String, String[]>();
        convertedSolrParams.putAll(SolrSearchHandlerUtil.toMultiMap(solrParams.toNamedList()));
        return convertedSolrParams;
    }

    public static void setNewSolrParameters(SolrQueryRequest request, HashMap<String, String[]> convertedSolrParams) {
        request.setParams((SolrParams)new MultiMapSolrParams(convertedSolrParams));
    }

    public static Map<String, String[]> toMultiMap(NamedList params) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (int i = 0; i < params.size(); ++i) {
            String name = params.getName(i);
            logger.debug(name);
            Object value = params.getVal(i);
            if (value instanceof String[]) {
                for (String val : (String[])value) {
                    MultiMapSolrParams.addParam((String)name, (String)val, map);
                }
                continue;
            }
            MultiMapSolrParams.addParam((String)name, (String)value.toString(), map);
        }
        return map;
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

