/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class NamespaceStack {
    private DocumentFactory documentFactory;
    private ArrayList namespaceStack = new ArrayList();
    private ArrayList namespaceCacheList = new ArrayList();
    private Map currentNamespaceCache;
    private Map rootNamespaceCache = new HashMap();
    private Namespace defaultNamespace;

    public NamespaceStack() {
        this.documentFactory = DocumentFactory.getInstance();
    }

    public NamespaceStack(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public void push(Namespace namespace2) {
        this.namespaceStack.add(namespace2);
        this.namespaceCacheList.add(null);
        this.currentNamespaceCache = null;
        String prefix = namespace2.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.defaultNamespace = namespace2;
        }
    }

    public Namespace pop() {
        return this.remove(this.namespaceStack.size() - 1);
    }

    public int size() {
        return this.namespaceStack.size();
    }

    public void clear() {
        this.namespaceStack.clear();
        this.namespaceCacheList.clear();
        this.rootNamespaceCache.clear();
        this.currentNamespaceCache = null;
    }

    public Namespace getNamespace(int index) {
        return (Namespace)this.namespaceStack.get(index);
    }

    public Namespace getNamespaceForPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            Namespace namespace2 = (Namespace)this.namespaceStack.get(i);
            if (!prefix.equals(namespace2.getPrefix())) continue;
            return namespace2;
        }
        return null;
    }

    public String getURI(String prefix) {
        Namespace namespace2 = this.getNamespaceForPrefix(prefix);
        return namespace2 != null ? namespace2.getURI() : null;
    }

    public boolean contains(Namespace namespace2) {
        String prefix = namespace2.getPrefix();
        Namespace current = null;
        current = prefix == null || prefix.length() == 0 ? this.getDefaultNamespace() : this.getNamespaceForPrefix(prefix);
        if (current == null) {
            return false;
        }
        if (current == namespace2) {
            return true;
        }
        return namespace2.getURI().equals(current.getURI());
    }

    public QName getQName(String namespaceURI, String localName, String qualifiedName) {
        if (localName == null) {
            localName = qualifiedName;
        } else if (qualifiedName == null) {
            qualifiedName = localName;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String prefix = "";
        int index = qualifiedName.indexOf(":");
        if (index > 0) {
            prefix = qualifiedName.substring(0, index);
            if (localName.trim().length() == 0) {
                localName = qualifiedName.substring(index + 1);
            }
        } else if (localName.trim().length() == 0) {
            localName = qualifiedName;
        }
        Namespace namespace2 = this.createNamespace(prefix, namespaceURI);
        return this.pushQName(localName, qualifiedName, namespace2, prefix);
    }

    public QName getAttributeQName(String namespaceURI, String localName, String qualifiedName) {
        Map map;
        QName answer;
        if (qualifiedName == null) {
            qualifiedName = localName;
        }
        if ((answer = (QName)(map = this.getNamespaceCache()).get(qualifiedName)) != null) {
            return answer;
        }
        if (localName == null) {
            localName = qualifiedName;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        Namespace namespace2 = null;
        String prefix = "";
        int index = qualifiedName.indexOf(":");
        if (index > 0) {
            prefix = qualifiedName.substring(0, index);
            namespace2 = this.createNamespace(prefix, namespaceURI);
            if (localName.trim().length() == 0) {
                localName = qualifiedName.substring(index + 1);
            }
        } else {
            namespace2 = Namespace.NO_NAMESPACE;
            if (localName.trim().length() == 0) {
                localName = qualifiedName;
            }
        }
        answer = this.pushQName(localName, qualifiedName, namespace2, prefix);
        map.put(qualifiedName, answer);
        return answer;
    }

    public void push(String prefix, String uri) {
        if (uri == null) {
            uri = "";
        }
        Namespace namespace2 = this.createNamespace(prefix, uri);
        this.push(namespace2);
    }

    public Namespace addNamespace(String prefix, String uri) {
        Namespace namespace2 = this.createNamespace(prefix, uri);
        this.push(namespace2);
        return namespace2;
    }

    public Namespace pop(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Namespace namespace2 = null;
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            Namespace ns = (Namespace)this.namespaceStack.get(i);
            if (!prefix.equals(ns.getPrefix())) continue;
            this.remove(i);
            namespace2 = ns;
            break;
        }
        if (namespace2 == null) {
            System.out.println("Warning: missing namespace prefix ignored: " + prefix);
        }
        return namespace2;
    }

    public String toString() {
        return super.toString() + " Stack: " + this.namespaceStack.toString();
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public Namespace getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = this.findDefaultNamespace();
        }
        return this.defaultNamespace;
    }

    protected QName pushQName(String localName, String qualifiedName, Namespace namespace2, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.defaultNamespace = null;
        }
        return this.createQName(localName, qualifiedName, namespace2);
    }

    protected QName createQName(String localName, String qualifiedName, Namespace namespace2) {
        return this.documentFactory.createQName(localName, namespace2);
    }

    protected Namespace createNamespace(String prefix, String namespaceURI) {
        return this.documentFactory.createNamespace(prefix, namespaceURI);
    }

    protected Namespace findDefaultNamespace() {
        for (int i = this.namespaceStack.size() - 1; i >= 0; --i) {
            String prefix;
            Namespace namespace2 = (Namespace)this.namespaceStack.get(i);
            if (namespace2 == null || (prefix = namespace2.getPrefix()) != null && namespace2.getPrefix().length() != 0) continue;
            return namespace2;
        }
        return null;
    }

    protected Namespace remove(int index) {
        Namespace namespace2 = (Namespace)this.namespaceStack.remove(index);
        this.namespaceCacheList.remove(index);
        this.defaultNamespace = null;
        this.currentNamespaceCache = null;
        return namespace2;
    }

    protected Map getNamespaceCache() {
        if (this.currentNamespaceCache == null) {
            int index = this.namespaceStack.size() - 1;
            if (index < 0) {
                this.currentNamespaceCache = this.rootNamespaceCache;
            } else {
                this.currentNamespaceCache = (Map)this.namespaceCacheList.get(index);
                if (this.currentNamespaceCache == null) {
                    this.currentNamespaceCache = new HashMap();
                    this.namespaceCacheList.set(index, this.currentNamespaceCache);
                }
            }
        }
        return this.currentNamespaceCache;
    }
}

