/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.buildtime.ExecutionException;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.Logger;
import org.hibernate.bytecode.util.ByteCodeHelper;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.bytecode.util.FieldFilter;

public abstract class AbstractInstrumenter
implements Instrumenter {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    protected final Logger logger;
    protected final Instrumenter.Options options;

    public AbstractInstrumenter(Logger logger, Instrumenter.Options options) {
        this.logger = logger;
        this.options = options;
    }

    protected abstract ClassDescriptor getClassDescriptor(byte[] var1) throws Exception;

    protected abstract ClassTransformer getClassTransformer(ClassDescriptor var1, Set var2);

    public void execute(Set files) {
        HashSet classNames = new HashSet();
        if (this.options.performExtendedInstrumentation()) {
            this.logger.debug("collecting class names for extended instrumentation determination");
            try {
                for (File file : files) {
                    this.collectClassNames(file, classNames);
                }
            }
            catch (ExecutionException ee) {
                throw ee;
            }
            catch (Exception e2) {
                throw new ExecutionException(e2);
            }
        }
        this.logger.info("starting instrumentation");
        try {
            for (File file : files) {
                this.processFile(file, classNames);
            }
        }
        catch (ExecutionException ee) {
            throw ee;
        }
        catch (Exception e3) {
            throw new ExecutionException(e3);
        }
    }

    private void collectClassNames(File file, final Set classNames) throws Exception {
        if (this.isClassFile(file)) {
            byte[] bytes = ByteCodeHelper.readByteCode(file);
            ClassDescriptor descriptor = this.getClassDescriptor(bytes);
            classNames.add(descriptor.getName());
        } else if (this.isJarFile(file)) {
            ZipEntryHandler collector = new ZipEntryHandler(){

                public void handleEntry(ZipEntry entry, byte[] byteCode) throws Exception {
                    DataInputStream din;
                    if (!entry.isDirectory() && (din = new DataInputStream(new ByteArrayInputStream(byteCode))).readInt() == -889275714) {
                        classNames.add(AbstractInstrumenter.this.getClassDescriptor(byteCode).getName());
                    }
                }
            };
            ZipFileProcessor processor = new ZipFileProcessor(collector);
            processor.process(file);
        }
    }

    protected final boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    protected final boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkMagic(File file, long magic) throws IOException {
        boolean bl;
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        try {
            int m = in.readInt();
            bl = magic == (long)m;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return bl;
    }

    protected void processFile(File file, Set classNames) throws Exception {
        if (this.isClassFile(file)) {
            this.logger.debug("processing class file : " + file.getAbsolutePath());
            this.processClassFile(file, classNames);
        } else if (this.isJarFile(file)) {
            this.logger.debug("processing jar file : " + file.getAbsolutePath());
            this.processJarFile(file, classNames);
        } else {
            this.logger.debug("ignoring file : " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClassFile(File file, Set classNames) throws Exception {
        byte[] bytes = ByteCodeHelper.readByteCode(file);
        ClassDescriptor descriptor = this.getClassDescriptor(bytes);
        ClassTransformer transformer = this.getClassTransformer(descriptor, classNames);
        if (transformer == null) {
            this.logger.debug("no trasformer for class file : " + file.getAbsolutePath());
            return;
        }
        this.logger.info("processing class : " + descriptor.getName() + ";  file = " + file.getAbsolutePath());
        byte[] transformedBytes = transformer.transform(this.getClass().getClassLoader(), descriptor.getName(), null, null, descriptor.getBytes());
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(transformedBytes);
            out.flush();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException ignore) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(final File file, final Set classNames) throws Exception {
        File tempFile = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
        try {
            FileOutputStream fout = new FileOutputStream(tempFile, false);
            try {
                final ZipOutputStream out = new ZipOutputStream(fout);
                ZipEntryHandler transformer = new ZipEntryHandler(){

                    public void handleEntry(ZipEntry entry, byte[] byteCode) throws Exception {
                        AbstractInstrumenter.this.logger.debug("starting zip entry : " + entry.toString());
                        if (!entry.isDirectory()) {
                            DataInputStream din = new DataInputStream(new ByteArrayInputStream(byteCode));
                            if (din.readInt() == -889275714) {
                                ClassDescriptor descriptor = AbstractInstrumenter.this.getClassDescriptor(byteCode);
                                ClassTransformer transformer = AbstractInstrumenter.this.getClassTransformer(descriptor, classNames);
                                if (transformer == null) {
                                    AbstractInstrumenter.this.logger.debug("no transformer for zip entry :  " + entry.toString());
                                } else {
                                    AbstractInstrumenter.this.logger.info("processing class : " + descriptor.getName() + ";  entry = " + file.getAbsolutePath());
                                    byteCode = transformer.transform(this.getClass().getClassLoader(), descriptor.getName(), null, null, descriptor.getBytes());
                                }
                            } else {
                                AbstractInstrumenter.this.logger.debug("ignoring zip entry : " + entry.toString());
                            }
                        }
                        ZipEntry outEntry = new ZipEntry(entry.getName());
                        outEntry.setMethod(entry.getMethod());
                        outEntry.setComment(entry.getComment());
                        outEntry.setSize(byteCode.length);
                        if (outEntry.getMethod() == 0) {
                            CRC32 crc = new CRC32();
                            crc.update(byteCode);
                            outEntry.setCrc(crc.getValue());
                            outEntry.setCompressedSize(byteCode.length);
                        }
                        out.putNextEntry(outEntry);
                        out.write(byteCode);
                        out.closeEntry();
                    }
                };
                ZipFileProcessor processor = new ZipFileProcessor(transformer);
                processor.process(file);
                out.close();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                fout.close();
                throw throwable;
            }
            fout.close();
            if (file.delete()) {
                File newFile = new File(tempFile.getAbsolutePath());
                if (!newFile.renameTo(file)) {
                    throw new IOException("can not rename " + tempFile + " to " + file);
                }
            } else {
                throw new IOException("can not delete " + file);
            }
            Object var11_11 = null;
            if (!tempFile.delete()) {
                this.logger.info("Unable to cleanup temporary jar file : " + tempFile.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!tempFile.delete()) {
                this.logger.info("Unable to cleanup temporary jar file : " + tempFile.getAbsolutePath());
            }
            throw throwable;
        }
    }

    private static class ZipFileProcessor {
        private final ZipEntryHandler entryHandler;

        public ZipFileProcessor(ZipEntryHandler entryHandler) {
            this.entryHandler = entryHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(File file) throws Exception {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    byte[] bytes = ByteCodeHelper.readByteCode(zip);
                    this.entryHandler.handleEntry(entry, bytes);
                    zip.closeEntry();
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                zip.close();
                throw throwable;
            }
            zip.close();
        }
    }

    private static interface ZipEntryHandler {
        public void handleEntry(ZipEntry var1, byte[] var2) throws Exception;
    }

    protected class CustomFieldFilter
    implements FieldFilter {
        private final ClassDescriptor descriptor;
        private final Set classNames;

        public CustomFieldFilter(ClassDescriptor descriptor, Set classNames) {
            this.descriptor = descriptor;
            this.classNames = classNames;
        }

        public boolean shouldInstrumentField(String className, String fieldName) {
            if (this.descriptor.getName().equals(className)) {
                AbstractInstrumenter.this.logger.trace("accepting transformation of field [" + className + "." + fieldName + "]");
                return true;
            }
            AbstractInstrumenter.this.logger.trace("rejecting transformation of field [" + className + "." + fieldName + "]");
            return false;
        }

        public boolean shouldTransformFieldAccess(String transformingClassName, String fieldOwnerClassName, String fieldName) {
            if (this.descriptor.getName().equals(fieldOwnerClassName)) {
                AbstractInstrumenter.this.logger.trace("accepting transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
                return true;
            }
            if (AbstractInstrumenter.this.options.performExtendedInstrumentation() && this.classNames.contains(fieldOwnerClassName)) {
                AbstractInstrumenter.this.logger.trace("accepting extended transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
                return true;
            }
            AbstractInstrumenter.this.logger.trace("rejecting transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]; caller = " + transformingClassName);
            return false;
        }
    }
}

