/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.ICharacterEscaper;
import org.jibx.runtime.IExtensibleWriter;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.GenericXMLWriter;
import org.jibx.runtime.impl.ISO88591Escaper;
import org.jibx.runtime.impl.ISO88591StreamWriter;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.runtime.impl.StAXWriter;
import org.jibx.runtime.impl.StringIntHashMap;
import org.jibx.runtime.impl.USASCIIEscaper;
import org.jibx.runtime.impl.UTF8Escaper;
import org.jibx.runtime.impl.UTF8StreamWriter;

public class MarshallingContext
implements IMarshallingContext {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final int INITIAL_STACK_SIZE = 20;
    private IBindingFactory m_factory;
    private StringIntHashMap m_classIndexMap;
    private String[] m_classes;
    private int m_transientBase;
    private String[] m_transientMarshallerClasses;
    private IMarshaller[] m_marshallers;
    private String[] m_uris;
    private int m_stackDepth;
    private Object[] m_objectStack;
    private int m_indentCount;
    private String m_newLine;
    private char m_indentChar;
    private HashMap m_idMap;
    private IXMLWriter m_writer;
    private OutByteBuffer m_byteBuffer;
    protected Object m_userContext;

    public MarshallingContext(String[] classes, String[] mcs, String[] uris, IBindingFactory ifact) {
        this.m_classes = classes;
        this.m_marshallers = new IMarshaller[classes.length];
        this.m_transientBase = classes.length - mcs.length;
        this.m_transientMarshallerClasses = new String[classes.length - this.m_transientBase];
        this.m_uris = uris;
        this.m_objectStack = new Object[20];
        this.m_indentCount = -1;
        this.m_indentChar = (char)32;
        this.m_newLine = "\n";
        this.m_factory = ifact;
        this.m_classIndexMap = ifact != null ? ifact.getClassIndexMap() : new StringIntHashMap();
    }

    private ICharacterEscaper createEscaper(String enc) throws JiBXException {
        if (enc.equalsIgnoreCase("UTF-8") || enc.equalsIgnoreCase("UTF-16") || enc.equalsIgnoreCase("UTF-16BE") || enc.equalsIgnoreCase("UTF-16LE")) {
            return UTF8Escaper.getInstance();
        }
        if (enc.equalsIgnoreCase("ISO-8859-1")) {
            return ISO88591Escaper.getInstance();
        }
        if (enc.equalsIgnoreCase("US-ASCII")) {
            return USASCIIEscaper.getInstance();
        }
        throw new JiBXException("No character escaper defined for encoding " + enc);
    }

    public void setOutput(OutputStream outs, String enc, ICharacterEscaper esc) throws JiBXException {
        try {
            if (enc == null) {
                enc = "UTF-8";
            }
            if (!(this.m_writer instanceof GenericXMLWriter)) {
                this.m_writer = new GenericXMLWriter(this.m_uris);
                this.m_writer.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outs, enc));
            ((GenericXMLWriter)this.m_writer).setOutput(writer, esc);
            this.reset();
        }
        catch (IOException ex) {
            throw new JiBXException("Error setting output", ex);
        }
    }

    public void setOutput(OutputStream outs, String enc) throws JiBXException {
        if (enc == null) {
            enc = "UTF-8";
        }
        if ("UTF-8".equalsIgnoreCase(enc)) {
            if (!(this.m_writer instanceof UTF8StreamWriter)) {
                if (this.m_byteBuffer == null) {
                    this.m_byteBuffer = new OutByteBuffer();
                }
                UTF8StreamWriter wrtr = new UTF8StreamWriter(this.m_uris);
                this.m_writer = wrtr;
                wrtr.setBuffer(this.m_byteBuffer);
                wrtr.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
            }
            this.reset();
            this.m_byteBuffer.setOutput(outs);
        } else if ("ISO-8859-1".equalsIgnoreCase(enc)) {
            if (!(this.m_writer instanceof ISO88591StreamWriter)) {
                if (this.m_byteBuffer == null) {
                    this.m_byteBuffer = new OutByteBuffer();
                }
                ISO88591StreamWriter wrtr = new ISO88591StreamWriter(this.m_uris);
                this.m_writer = wrtr;
                wrtr.setBuffer(this.m_byteBuffer);
                wrtr.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
            }
            this.reset();
            this.m_byteBuffer.setOutput(outs);
        } else {
            this.setOutput(outs, enc, this.createEscaper(enc));
        }
    }

    public void setOutput(Writer outw, ICharacterEscaper esc) {
        if (!(this.m_writer instanceof GenericXMLWriter)) {
            this.m_writer = new GenericXMLWriter(this.m_uris);
            this.m_writer.setIndentSpaces(this.m_indentCount, this.m_newLine, this.m_indentChar);
        }
        ((GenericXMLWriter)this.m_writer).setOutput(outw, esc);
        this.reset();
    }

    public void setOutput(Writer outw) {
        this.setOutput(outw, UTF8Escaper.getInstance());
    }

    public IXMLWriter getXmlWriter() {
        return this.m_writer;
    }

    public void setXmlWriter(IXMLWriter xwrite) {
        this.m_writer = xwrite;
    }

    public int getIndent() {
        return this.m_indentCount;
    }

    public void setIndent(int count) {
        if (this.m_writer != null) {
            this.m_writer.setIndentSpaces(count, this.m_newLine, this.m_indentChar);
        }
        this.m_indentCount = count;
    }

    public void setIndent(int count, String newline, char indent) {
        if (this.m_writer != null) {
            this.m_writer.setIndentSpaces(count, newline, indent);
        }
        this.m_indentCount = count;
        this.m_newLine = newline;
        this.m_indentChar = indent;
    }

    public void setFromContext(MarshallingContext parent) throws IOException {
        this.reset();
        this.m_indentCount = parent.m_indentCount;
        this.m_newLine = parent.m_newLine;
        this.m_indentChar = parent.m_indentChar;
        if (parent.m_writer instanceof IExtensibleWriter) {
            IExtensibleWriter base = (IExtensibleWriter)parent.m_writer;
            base.flush();
            this.m_writer = base.createChildWriter(this.m_uris);
        } else {
            this.m_writer = parent.m_writer instanceof StAXWriter ? ((StAXWriter)parent.m_writer).createChildWriter(this.m_uris) : parent.m_writer;
        }
    }

    public void reset() {
        int i;
        if (this.m_writer != null) {
            this.m_writer.reset();
        }
        for (i = 0; i < this.m_marshallers.length; ++i) {
            this.m_marshallers[i] = null;
        }
        for (i = 0; i < this.m_transientMarshallerClasses.length; ++i) {
            this.m_transientMarshallerClasses[i] = null;
        }
        for (i = 0; i < this.m_objectStack.length; ++i) {
            this.m_objectStack[i] = null;
        }
        this.m_stackDepth = 0;
    }

    public IBindingFactory getFactory() {
        return this.m_factory;
    }

    public String[] getNamespaces() {
        return this.m_uris;
    }

    public void startDocument(String enc, Boolean alone) throws JiBXException {
        try {
            String atext = null;
            if (alone != null) {
                atext = alone != false ? "yes" : "no";
            }
            this.m_writer.writeXMLDecl("1.0", enc, atext);
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public void startDocument(String enc, Boolean alone, OutputStream outs) throws JiBXException {
        this.setOutput(outs, enc);
        this.startDocument(enc, alone);
    }

    public void startDocument(String enc, Boolean alone, Writer outw) throws JiBXException {
        this.setOutput(outw);
        this.startDocument(enc, alone);
    }

    public void endDocument() throws JiBXException {
        try {
            this.m_writer.close();
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public String buildNameString(int index, String name) {
        String ns = this.m_writer.getNamespaceUri(index);
        if (ns == null || "".equals(ns)) {
            return "\"" + name + "\"";
        }
        return "\"{" + ns + "}" + name + "\"";
    }

    public MarshallingContext startTag(int index, String name) throws JiBXException {
        try {
            this.m_writer.startTagClosed(index, name);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext startTagAttributes(int index, String name) throws JiBXException {
        try {
            this.m_writer.startTagOpen(index, name);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext attribute(int index, String name, String value) throws JiBXException {
        try {
            this.m_writer.addAttribute(index, name, value);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
        catch (Exception ex) {
            String text = this.buildNameString(index, name);
            if (value == null) {
                throw new JiBXException("null value for attribute " + text + " from object of type " + this.getStackTop().getClass().getName());
            }
            throw new JiBXException("Exception while marshalling attribute " + text, ex);
        }
    }

    public MarshallingContext attribute(int index, String name, int value) throws JiBXException {
        return this.attribute(index, name, Integer.toString(value));
    }

    public MarshallingContext attribute(int index, String name, int value, String[] table) throws JiBXException {
        try {
            return this.attribute(index, name, table[value]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new JiBXException("Enumeration value of " + value + " is outside to allowed range of 0 to " + table.length);
        }
    }

    public MarshallingContext closeStartContent() throws JiBXException {
        try {
            this.m_writer.closeStartTag();
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext closeStartEmpty() throws JiBXException {
        try {
            this.m_writer.closeEmptyTag();
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext content(String value) throws JiBXException {
        try {
            this.m_writer.writeTextContent(value);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext content(int value) throws JiBXException {
        this.content(Integer.toString(value));
        return this;
    }

    public MarshallingContext content(int value, String[] table) throws JiBXException {
        try {
            this.content(table[value]);
            return this;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new JiBXException("Enumeration value of " + value + " is outside to allowed range of 0 to " + table.length);
        }
    }

    public MarshallingContext endTag(int index, String name) throws JiBXException {
        try {
            this.m_writer.endTag(index, name);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public MarshallingContext element(int index, String name, String value) throws JiBXException {
        try {
            if (value.length() == 0) {
                this.m_writer.startTagOpen(index, name);
                this.m_writer.closeEmptyTag();
            } else {
                this.m_writer.startTagClosed(index, name);
                this.m_writer.writeTextContent(value);
                this.m_writer.endTag(index, name);
            }
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
        catch (Exception ex) {
            String text = this.buildNameString(index, name);
            if (value == null) {
                throw new JiBXException("null value for element " + text + " from object of type " + this.getStackTop().getClass().getName());
            }
            throw new JiBXException("Exception while marshalling element " + text, ex);
        }
    }

    public MarshallingContext element(int index, String name, int value) throws JiBXException {
        return this.element(index, name, Integer.toString(value));
    }

    public MarshallingContext element(int index, String name, int value, String[] table) throws JiBXException {
        try {
            return this.element(index, name, table[value]);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new JiBXException("Enumeration value of " + value + " is outside to allowed range of 0 to " + table.length);
        }
    }

    public MarshallingContext writeCData(String text) throws IOException {
        try {
            this.m_writer.writeCData(text);
            return this;
        }
        catch (NullPointerException e2) {
            if (text == null) {
                throw new IOException("Null value writing CDATA from object of type " + this.getStackTop().getClass().getName());
            }
            throw e2;
        }
    }

    public MarshallingContext writeContent(String text) throws IOException {
        try {
            this.m_writer.writeTextContent(text);
            return this;
        }
        catch (NullPointerException e2) {
            if (text == null) {
                throw new IOException("Null value writing text content from object " + this.getStackTop().getClass().getName());
            }
            throw e2;
        }
    }

    public MarshallingContext marshalCollection(Collection col) throws JiBXException {
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof IMarshallable) {
                ((IMarshallable)obj).marshal(this);
                continue;
            }
            throw new JiBXException("Unmarshallable object of class " + obj.getClass() + " found in marshalling");
        }
        return this;
    }

    public MarshallingContext marshalCollection(ArrayList col) throws JiBXException {
        for (int i = 0; i < col.size(); ++i) {
            Object obj = col.get(i);
            if (!(obj instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + obj.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)obj).marshal(this);
        }
        return this;
    }

    public MarshallingContext marshalCollection(Vector col) throws JiBXException {
        for (int i = 0; i < col.size(); ++i) {
            Object obj = col.elementAt(i);
            if (!(obj instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + obj.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)obj).marshal(this);
        }
        return this;
    }

    public void addMarshalling(String mapname, String name) throws JiBXException {
        int index = this.m_classIndexMap.get(mapname);
        if (index < 0) {
            throw new JiBXException("No marshal mapping defined for class " + mapname);
        }
        this.m_transientMarshallerClasses[index - this.m_transientBase] = name;
    }

    public void removeMarshalling(String mapname) throws JiBXException {
        int index = this.m_classIndexMap.get(mapname);
        if (index < 0) {
            throw new JiBXException("No marshal mapping defined for class " + mapname);
        }
        this.m_transientMarshallerClasses[index - this.m_transientBase] = null;
        this.m_marshallers[index] = null;
    }

    public MarshallingContext startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws JiBXException {
        try {
            this.m_writer.startTagNamespaces(index, name, nums, prefs);
            return this;
        }
        catch (IOException ex) {
            throw new JiBXException("Error writing marshalled document", ex);
        }
    }

    public IMarshaller getMarshaller(String mapname) throws JiBXException {
        int index = this.m_classIndexMap.get(mapname);
        if (index < 0) {
            throw new JiBXException("No marshal mapping defined for class " + mapname);
        }
        if (this.m_marshallers[index] == null) {
            Class clas;
            String mname = this.m_factory.getMarshallerClasses()[index];
            if (mname != null) {
                clas = this.m_factory.getMarshallerClass(index);
            } else {
                mname = this.m_transientMarshallerClasses[index - this.m_transientBase];
                if (mname == null) {
                    throw new JiBXException("No marshaller defined for class " + mapname);
                }
                clas = this.m_factory.loadClass(mname);
            }
            try {
                IMarshaller m;
                if (clas == null) {
                    throw new JiBXException("Unable to load marshaller class " + mname);
                }
                this.m_marshallers[index] = m = (IMarshaller)clas.newInstance();
            }
            catch (JiBXException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new JiBXException("Unable to create marshaller of class " + mname + ":", e3);
            }
        }
        return this.m_marshallers[index];
    }

    protected void marshalRoot(Object root) throws JiBXException {
        if (!(root instanceof IMarshallable)) {
            throw new JiBXException("Supplied root object of class " + root.getClass().getName() + " cannot be marshalled without top-level mapping");
        }
        ((IMarshallable)root).marshal(this);
    }

    public void marshalDocument(Object root) throws JiBXException {
        this.marshalRoot(root);
        this.endDocument();
    }

    public void marshalDocument(Object root, String enc, Boolean alone) throws JiBXException {
        this.startDocument(enc, alone);
        this.marshalRoot(root);
        this.endDocument();
    }

    public void marshalDocument(Object root, String enc, Boolean alone, OutputStream outs) throws JiBXException {
        this.startDocument(enc, alone, outs);
        this.marshalRoot(root);
        this.endDocument();
    }

    public void marshalDocument(Object root, String enc, Boolean alone, Writer outw) throws JiBXException {
        this.startDocument(enc, alone, outw);
        this.marshalRoot(root);
        this.endDocument();
    }

    public void pushNamespaces(String factname) {
        Map tablemap = this.m_factory.getNamespaceTranslationTableMap();
        this.m_writer.pushTranslationTable((int[])tablemap.get(factname));
    }

    public void popNamespaces() {
        this.m_writer.popTranslationTable();
    }

    public HashMap getIdMap() {
        if (this.m_idMap == null) {
            this.m_idMap = new HashMap();
        }
        return this.m_idMap;
    }

    public void setUserContext(Object obj) {
        this.m_userContext = obj;
    }

    public Object getUserContext() {
        return this.m_userContext;
    }

    public void pushObject(Object obj) {
        if (obj == null) {
            throw new IllegalStateException("Missing required object");
        }
        int depth = this.m_stackDepth;
        if (depth >= this.m_objectStack.length) {
            Object[] stack = new Object[depth * 2];
            System.arraycopy(this.m_objectStack, 0, stack, 0, depth);
            this.m_objectStack = stack;
        }
        this.m_objectStack[depth] = obj;
        ++this.m_stackDepth;
    }

    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    public int getStackDepth() {
        return this.m_stackDepth;
    }

    public Object getStackObject(int depth) {
        return this.m_objectStack[this.m_stackDepth - depth - 1];
    }

    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }
}

