/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionMetadata {
    private final Log logger = LogFactory.getLog(InjectionMetadata.class);
    private final Set<InjectedElement> injectedElements;

    public InjectionMetadata(Class targetClass, Collection<InjectedElement> elements) {
        if (!elements.isEmpty()) {
            this.injectedElements = Collections.synchronizedSet(new LinkedHashSet(elements.size()));
            for (InjectedElement element : elements) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found injected element on class [" + targetClass.getName() + "]: " + element);
                }
                this.injectedElements.add(element);
            }
        } else {
            this.injectedElements = Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConfigMembers(RootBeanDefinition beanDefinition) {
        Set<InjectedElement> set = this.injectedElements;
        synchronized (set) {
            Iterator<InjectedElement> it = this.injectedElements.iterator();
            while (it.hasNext()) {
                Member member = it.next().getMember();
                if (!beanDefinition.isExternallyManagedConfigMember(member)) {
                    beanDefinition.registerExternallyManagedConfigMember(member);
                    continue;
                }
                it.remove();
            }
        }
    }

    public void inject(Object target, String beanName, PropertyValues pvs) throws Throwable {
        if (!this.injectedElements.isEmpty()) {
            boolean debug2 = this.logger.isDebugEnabled();
            for (InjectedElement element : this.injectedElements) {
                if (debug2) {
                    this.logger.debug("Processing injected method of bean '" + beanName + "': " + element);
                }
                element.inject(target, beanName, pvs);
            }
        }
    }

    public static abstract class InjectedElement {
        protected final Member member;
        protected final boolean isField;
        protected final PropertyDescriptor pd;
        protected volatile Boolean skip;

        protected InjectedElement(Member member, PropertyDescriptor pd) {
            this.member = member;
            this.isField = member instanceof Field;
            this.pd = pd;
        }

        public final Member getMember() {
            return this.member;
        }

        protected final Class getResourceType() {
            if (this.isField) {
                return ((Field)this.member).getType();
            }
            if (this.pd != null) {
                return this.pd.getPropertyType();
            }
            return ((Method)this.member).getParameterTypes()[0];
        }

        protected final void checkResourceType(Class resourceType) {
            if (this.isField) {
                Class<?> fieldType = ((Field)this.member).getType();
                if (!resourceType.isAssignableFrom(fieldType) && !fieldType.isAssignableFrom(resourceType)) {
                    throw new IllegalStateException("Specified field type [" + fieldType + "] is incompatible with resource type [" + resourceType.getName() + "]");
                }
            } else {
                Class<?> paramType;
                Class<?> clazz = paramType = this.pd != null ? this.pd.getPropertyType() : ((Method)this.member).getParameterTypes()[0];
                if (!resourceType.isAssignableFrom(paramType) && !paramType.isAssignableFrom(resourceType)) {
                    throw new IllegalStateException("Specified parameter type [" + paramType + "] is incompatible with resource type [" + resourceType.getName() + "]");
                }
            }
        }

        protected void inject(Object target, String requestingBeanName, PropertyValues pvs) throws Throwable {
            if (this.isField) {
                Field field = (Field)this.member;
                ReflectionUtils.makeAccessible((Field)field);
                field.set(target, this.getResourceToInject(target, requestingBeanName));
            } else {
                if (this.checkPropertySkipping(pvs)) {
                    return;
                }
                try {
                    Method method = (Method)this.member;
                    ReflectionUtils.makeAccessible((Method)method);
                    method.invoke(target, this.getResourceToInject(target, requestingBeanName));
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean checkPropertySkipping(PropertyValues pvs) {
            if (this.skip != null) {
                return this.skip;
            }
            if (pvs == null) {
                this.skip = false;
                return false;
            }
            PropertyValues propertyValues = pvs;
            synchronized (propertyValues) {
                if (this.skip != null) {
                    return this.skip;
                }
                if (this.pd != null) {
                    if (pvs.contains(this.pd.getName())) {
                        this.skip = true;
                        return true;
                    }
                    if (pvs instanceof MutablePropertyValues) {
                        ((MutablePropertyValues)pvs).registerProcessedProperty(this.pd.getName());
                    }
                }
                this.skip = false;
                return false;
            }
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            return null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InjectedElement)) {
                return false;
            }
            InjectedElement otherElement = (InjectedElement)other;
            return this.member.equals(otherElement.member);
        }

        public int hashCode() {
            return this.member.getClass().hashCode() * 29 + this.member.getName().hashCode();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.member;
        }
    }
}

