/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BeanWrapper<E extends PersistentEntity<T, ?>, T> {
    private final T bean;
    private final ConversionService conversionService;

    public static <E extends PersistentEntity<T, ?>, T> BeanWrapper<E, T> create(T bean, ConversionService conversionService) {
        return new BeanWrapper<E, T>(bean, conversionService);
    }

    private BeanWrapper(T bean, ConversionService conversionService) {
        Assert.notNull(bean);
        this.bean = bean;
        this.conversionService = conversionService;
    }

    public void setProperty(PersistentProperty<?> property, Object value) {
        this.setProperty(property, value, false);
    }

    public void setProperty(PersistentProperty<?> property, Object value, boolean fieldAccessOnly) {
        Method setter = property.getSetter();
        try {
            if (fieldAccessOnly || null == setter) {
                Object valueToSet = this.getPotentiallyConvertedValue(value, property.getType());
                ReflectionUtils.makeAccessible((Field)property.getField());
                ReflectionUtils.setField((Field)property.getField(), this.bean, valueToSet);
                return;
            }
            Class<?>[] paramTypes = setter.getParameterTypes();
            Object valueToSet = this.getPotentiallyConvertedValue(value, paramTypes[0]);
            ReflectionUtils.makeAccessible((Method)setter);
            ReflectionUtils.invokeMethod((Method)setter, this.bean, (Object[])new Object[]{valueToSet});
        }
        catch (IllegalStateException e2) {
            throw new MappingException("Could not set object property!", e2);
        }
    }

    public Object getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType(), false);
    }

    public <S> S getProperty(PersistentProperty<?> property, Class<? extends S> type, boolean fieldAccessOnly) {
        try {
            Object obj;
            Field field = property.getField();
            Method getter = property.getGetter();
            if (fieldAccessOnly || null == getter) {
                ReflectionUtils.makeAccessible((Field)field);
                obj = ReflectionUtils.getField((Field)field, this.bean);
            } else {
                ReflectionUtils.makeAccessible((Method)getter);
                obj = ReflectionUtils.invokeMethod((Method)getter, this.bean);
            }
            return this.getPotentiallyConvertedValue(obj, type);
        }
        catch (IllegalStateException e2) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e2);
        }
    }

    private <S> S getPotentiallyConvertedValue(Object source, Class<S> targetType) {
        boolean conversionNeeded;
        boolean conversionServiceAvailable = this.conversionService != null;
        boolean bl = conversionNeeded = source == null || !targetType.isAssignableFrom(source.getClass());
        if (conversionServiceAvailable && conversionNeeded) {
            return (S)this.conversionService.convert(source, targetType);
        }
        return (S)source;
    }

    public T getBean() {
        return this.bean;
    }
}

