/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryBeanNameGenerator;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class RepositoryBeanDefinitionRegistrarSupport
implements ImportBeanDefinitionRegistrar,
BeanClassLoaderAware,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private ClassLoader beanClassLoader;
    private Environment environment;

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata);
        Assert.notNull((Object)registry);
        if (annotationMetadata.getAnnotationAttributes(this.getAnnotation().getName()) == null) {
            return;
        }
        this.defaultExternalResources(registry);
        AnnotationRepositoryConfigurationSource configuration = new AnnotationRepositoryConfigurationSource(annotationMetadata, this.getAnnotation(), this.resourceLoader, this.environment);
        RepositoryConfigurationExtension extension = this.getExtension();
        extension.registerBeansForRoot(registry, configuration);
        RepositoryBeanNameGenerator generator = new RepositoryBeanNameGenerator();
        generator.setBeanClassLoader(this.beanClassLoader);
        for (RepositoryConfiguration<AnnotationRepositoryConfigurationSource> repositoryConfiguration : extension.getRepositoryConfigurations(configuration, this.resourceLoader)) {
            RepositoryBeanDefinitionBuilder builder = new RepositoryBeanDefinitionBuilder(repositoryConfiguration, extension);
            BeanDefinitionBuilder definitionBuilder = builder.build(registry, this.resourceLoader);
            extension.postProcess(definitionBuilder, configuration);
            String beanName = generator.generateBeanName(definitionBuilder.getBeanDefinition(), registry);
            registry.registerBeanDefinition(beanName, definitionBuilder.getBeanDefinition());
        }
    }

    private void defaultExternalResources(BeanDefinitionRegistry registry) {
        if (this.beanClassLoader == null) {
            this.beanClassLoader = this.getBeanClassLoader(registry);
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = new DefaultResourceLoader(this.beanClassLoader);
        }
    }

    private ClassLoader getBeanClassLoader(BeanDefinitionRegistry registry) {
        if (registry instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)((Object)registry)).getBeanClassLoader();
        }
        return this.resourceLoader == null ? ClassUtils.getDefaultClassLoader() : this.resourceLoader.getClassLoader();
    }

    protected abstract Class<? extends Annotation> getAnnotation();

    protected abstract RepositoryConfigurationExtension getExtension();
}

