/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.util.Assert;

public abstract class DatabasePopulatorUtils {
    public static void execute(DatabasePopulator populator, DataSource dataSource) {
        Assert.notNull((Object)populator, (String)"DatabasePopulator must be provided");
        Assert.notNull((Object)dataSource, (String)"DataSource must be provided");
        try {
            Connection connection = DataSourceUtils.getConnection(dataSource);
            try {
                populator.populate(connection);
            }
            finally {
                if (connection != null) {
                    DataSourceUtils.releaseConnection(connection, dataSource);
                }
            }
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Failed to execute database script", ex);
        }
    }
}

