/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.config.TxNamespaceHandler;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TxAdviceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ATTRIBUTES = "attributes";
    private static final String TIMEOUT = "timeout";
    private static final String READ_ONLY = "read-only";
    private static final String NAME_MAP = "nameMap";
    private static final String PROPAGATION = "propagation";
    private static final String ISOLATION = "isolation";
    private static final String ROLLBACK_FOR = "rollback-for";
    private static final String NO_ROLLBACK_FOR = "no-rollback-for";

    TxAdviceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return TransactionInterceptor.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyReference("transactionManager", TxNamespaceHandler.getTransactionManagerName(element));
        List txAttributes = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTES);
        if (txAttributes.size() > 1) {
            parserContext.getReaderContext().error("Element <attributes> is allowed at most once inside element <advice>", element);
        } else if (txAttributes.size() == 1) {
            Element attributeSourceElement = (Element)txAttributes.get(0);
            RootBeanDefinition attributeSourceDefinition = this.parseAttributeSource(attributeSourceElement, parserContext);
            builder.addPropertyValue("transactionAttributeSource", attributeSourceDefinition);
        } else {
            builder.addPropertyValue("transactionAttributeSource", new RootBeanDefinition(AnnotationTransactionAttributeSource.class));
        }
    }

    private RootBeanDefinition parseAttributeSource(Element attrEle, ParserContext parserContext) {
        List methods = DomUtils.getChildElementsByTagName((Element)attrEle, (String)"method");
        ManagedMap<TypedStringValue, RuleBasedTransactionAttribute> transactionAttributeMap = new ManagedMap<TypedStringValue, RuleBasedTransactionAttribute>(methods.size());
        transactionAttributeMap.setSource(parserContext.extractSource(attrEle));
        for (Element methodEle : methods) {
            String name = methodEle.getAttribute("name");
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource(methodEle));
            RuleBasedTransactionAttribute attribute = new RuleBasedTransactionAttribute();
            String propagation = methodEle.getAttribute(PROPAGATION);
            String isolation = methodEle.getAttribute(ISOLATION);
            String timeout = methodEle.getAttribute(TIMEOUT);
            String readOnly = methodEle.getAttribute(READ_ONLY);
            if (StringUtils.hasText((String)propagation)) {
                attribute.setPropagationBehaviorName("PROPAGATION_" + propagation);
            }
            if (StringUtils.hasText((String)isolation)) {
                attribute.setIsolationLevelName("ISOLATION_" + isolation);
            }
            if (StringUtils.hasText((String)timeout)) {
                try {
                    attribute.setTimeout(Integer.parseInt(timeout));
                }
                catch (NumberFormatException numberFormatException) {
                    parserContext.getReaderContext().error("Timeout must be an integer value: [" + timeout + "]", methodEle);
                }
            }
            if (StringUtils.hasText((String)readOnly)) {
                attribute.setReadOnly(Boolean.valueOf(methodEle.getAttribute(READ_ONLY)));
            }
            LinkedList<RollbackRuleAttribute> rollbackRules = new LinkedList<RollbackRuleAttribute>();
            if (methodEle.hasAttribute(ROLLBACK_FOR)) {
                String rollbackForValue = methodEle.getAttribute(ROLLBACK_FOR);
                this.addRollbackRuleAttributesTo(rollbackRules, rollbackForValue);
            }
            if (methodEle.hasAttribute(NO_ROLLBACK_FOR)) {
                String noRollbackForValue = methodEle.getAttribute(NO_ROLLBACK_FOR);
                this.addNoRollbackRuleAttributesTo(rollbackRules, noRollbackForValue);
            }
            attribute.setRollbackRules(rollbackRules);
            transactionAttributeMap.put(nameHolder, attribute);
        }
        RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(NameMatchTransactionAttributeSource.class);
        attributeSourceDefinition.setSource(parserContext.extractSource(attrEle));
        attributeSourceDefinition.getPropertyValues().add(NAME_MAP, transactionAttributeMap);
        return attributeSourceDefinition;
    }

    private void addRollbackRuleAttributesTo(List<RollbackRuleAttribute> rollbackRules, String rollbackForValue) {
        String[] exceptionTypeNames;
        String[] stringArray = exceptionTypeNames = StringUtils.commaDelimitedListToStringArray((String)rollbackForValue);
        int n = exceptionTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            rollbackRules.add(new RollbackRuleAttribute(StringUtils.trimWhitespace((String)typeName)));
            ++n2;
        }
    }

    private void addNoRollbackRuleAttributesTo(List<RollbackRuleAttribute> rollbackRules, String noRollbackForValue) {
        String[] exceptionTypeNames;
        String[] stringArray = exceptionTypeNames = StringUtils.commaDelimitedListToStringArray((String)noRollbackForValue);
        int n = exceptionTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            rollbackRules.add(new NoRollbackRuleAttribute(StringUtils.trimWhitespace((String)typeName)));
            ++n2;
        }
    }
}

